	page	,132
	title	wcsrchr - find last occurence of character in wchar_t string
;***
;wcsrchr.asm - find last occurrence of character in wchar_t string
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsrchr() - find the last occurrence of a given wide character
;	in a wchar_t string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcsrchr(wcs, wc) - find last occurrence of wc in wcs
;
;Purpose:
;	Finds the last occurrence of wc in wcs.  The terminating
;	null character is used as part of the search.
;
;	Algorithm:
;	wchar_t *
;	wcsrchr (wcs, wc)
;	      wchar_t *wcs, wc;
;	      {
;	      wchar_t *start = wcs;
;
;	      while (*wcs++)
;		      ;
;	      while (--wcs != start && *wcs != wc)
;		      ;
;	      if (*wcs == wc)
;		      return(wcs);
;	      return(NULL);
;	      }
;
;Entry:
;	wchar_t *wcs - string to search in
;	wchar_t wc - character to search for
;
;Exit:
;	returns a pointer to the last occurrence of wc in the given
;	wchar_t string
;	returns NULL if wc does not occurr in the string
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsrchr,<PUBLIC>,<>

else

cProc	wcsrchr,<PUBLIC>,<>

endif

	parmdp	wcs
	parmw	wc

cBegin
	push	di

if	sizeD
	les	di,wcs	; di=pointer to string (es=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,wcs	; di=pointer to string
endif

	xor	ax,ax		; ax=null word
	mov	cx,-1
repne	scasw			; find the null & count words
	inc	cx		; cx=-word count (with null)
	neg	cx		; cx=+word count (with null)
	sub	di,2		; di points to terminal null
	mov	ax,wc		; ax=search word
	std			; count 'down' on string this time
repne	scasw			; find that word
	add	di,2		; di points to word which stopped scan

if	sizeD
	cmp	es:[di],ax	; see if we have a hit
else
	cmp	[di],ax 	; see if we have a hit
endif

	je	returndi	; yes, point to word

	xor	ax,ax		; no, return NULL

if	sizeD
	mov	dx,ax		; make dx NULL too
endif

	jmp	short toend	; do return sequence

returndi:
	mov	ax,di		; ax=pointer to word

if	sizeD
	mov	dx,es		; segment part of addr
endif

toend:
	cld
	pop	di
cEnd

% sEnd	CODE_SEG
	end
