	page	,132
	title	wcsrev - reverse a wchar_t string in place
;***
;wcsrev.asm - reverse a wchar_t string in place
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsrev() - reverse a wchar_t string in place (not including
;	L'\0' character)
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *_wcsrev(wcs) - reverse a wchar_t string in place
;
;Purpose:
;	Reverses the order of characters in the wchar_t string. The terminating
;	null character remains in place.
;
;	Algorithm:
;	char *
;	_wcsrev (wcs)
;	      char *wcs;
;	      {
;	      char *start = wcs;
;	      char *left = wcs;
;	      char ch;
;
;	      while (*wcs++)
;		      ;
;	      wcs -= 2;
;	      while (left < wcs)
;		      {
;		      ch = *left;
;		      *left++ = *wcs;
;		      *wcs-- = ch;
;		      }
;	      return(start);
;	      }
;
;	NOTE: There's a check for an empty wchar_t string in the following code.
;	Normally, this would fall out of the "cmp si,di" instruction in the
;	loop portion of the routine.  However, if the offset of the empty
;	string is 0 (as it could be in large model), then the cmp does not
;	catch the empty string and the routine essentially hangs (i.e., loops
;	moving words one at a time FFFFh times).  An explicit empty string
;	check corrects this.
;
;Entry:
;	char *wcs - string to reverse
;
;Exit:
;	returns wcs - now with reversed characters
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsrev,<PUBLIC>,<>

else

cProc	_wcsrev,<PUBLIC>,<>

endif

	parmdp	wcs

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	les	di,wcs		; di=pointer to string (es=segment part)
	push	es		; ds points there too
	pop	ds
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,wcs		; di=pointer to string
endif

	mov	bx,di		; bx=pointer to string; save return value
	mov	si,di		; si=pointer to string
	xor	ax,ax		; search value (null)
	mov	cx,-1
repne	scasw			; find null
	cmp	cx,-2		; is string empty? (if offset value is 0, the
	je	done		; cmp below will not catch it and we'll hang).

	sub	di,4		; string is not empty, move di pointer back

	xchg	si,di		; si points to last non-null word
				; di points to front of string

lupe:
	cmp	di,si		; see if pointers have crossed yet
	jae	done		; exit when pointers meet (or cross)

	mov	ax,[di] 	; get front word...
	xchg	ax,[si]		; exchange with back word...
	stosw			; and store back in front
				; front moves up...
	sub	si,2		; and back moves down
	jmp	short lupe	; keep switching words

done:
	xchg	ax,bx		; (mov ax,bx) return value: string addr

if	sizeD
	mov	dx,ds		; segment part of addr
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

% sEnd	CODE_SEG
	end
