	page	,132
	title	wcsset - set all wide characters of string to a given wchar_t
;***
;wcsset.asm - sets all wide characters of string to a given wide character
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsset() - sets all of the wide characters in a string (except
;	L'\0') equal to a given wide character.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *_wcsset(wcs, val) - sets all of wcs to val
;
;Purpose:
;	Sets all of characters in wcs (except the terminating '/0'
;	character) equal to val.
;
;	Algorithm:
;	wchar_t *
;	_wcsset (wcs, val)
;	      wchar_t *wcs;
;	      wchar_t val;
;	      {
;	      wchar_t *start = wcs;
;
;	      while (*wcs)
;		      *wcs++ = val;
;	      return(start);
;	      }
;
;Entry:
;	wchar_t *wcs - string to modify
;	wchar_t val - value to fill string with
;
;Exit:
;	returns wcs -- now filled with val's
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsset,<PUBLIC>,<>

else

cProc	_wcsset,<PUBLIC>,<>

endif

	parmdp	wcs
	parmw	val

cBegin
	push	di

if	sizeD
	les	di,wcs	; di=pointer to wchar_t string (es=segment part)
else
	mov	di,wcs	; di=pointer to wchar_t string
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	dx,di		; dx=wchar_t string addr; save return value
	xor	ax,ax		; ax=0
	mov	cx,-1
repne	scasw			; scan wchar_t string & count words
	inc	cx
	inc	cx		; cx=-wcslen
	neg	cx		; cx=wcslen
	mov	ax,val
	mov	di,dx		; di=wchar_t string addr
rep	stosw
	mov	ax,dx		; return value: wchar_t string addr

if	sizeD
	mov	dx,es		; put segment part of addr in dx
endif

	pop	di
cEnd

% sEnd	CODE_SEG
	end
