	page	,132
	title	wcsspn - search for init substring of wide chars from control
;***
;wcsspn.asm - find length of initial substring of wide chars from a control str
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsspn() - find the length of the initial substring of a wchar_t
;	string consisting entirely of wide characters from a control string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int wcsspn(wcs, control) - find init substring of control chars
;
;Purpose:
;	Finds the index of the first wide character in wcs that does belong
;	to the set of wide characters specified by control.	This is
;	equivalent to the length of the initial substring of wcs that
;	consists entirely of wide characters from control.  The L'\0' character
;	that terminates control is not considered in the matching process.
;
;	Algorithm:
;	int
;	wcsspn (wcs, control)
;		unsigned char *wcs, *control;
;	{
;		unsigned char map[32];
;		int count;
;
;		for (count = 0; count < 32; count++)
;			map[count] = 0;
;		while (*control)
;		{
;			map[*control >> 3] |= (1 << (*control & 7));
;			control++;
;		}
;		if (*wcs)
;		{
;			while (map[*wcs >> 3] & (1 << (*wcs & 7)))
;			{
;				count++;
;				wcs++;
;			}
;			return(count);
;		}
;		return(0);
;	}
;
;Entry:
;	char *wcs - string to search
;	char *control - string containing characters not to search for
;
;Exit:
;	returns index of first char in wide string not in control
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsspn,<PUBLIC>,<si,di>

else

cProc	wcsspn,<PUBLIC>,<si,di>

endif

	parmDP	wcs
	parmDP	control

cBegin

if sizeD
	push	ds
	assumes ds,nothing
	lds	si,wcs

	les	di,control
	assumes es,nothing
else
	mov	si,wcs
	mov	di,control
endif

	mov	dx,di
	xor	ax,ax

	mov	cx,-1
	repnz	scasw		; find end of wcs
	; consider: error if not found
	inc	cx
	neg	cx		; cx = wcslen(control) + 1
	mov	bx,cx


	lodsw			; read each wchar_t
list_loop:
	and	ax,ax		; until either we reach the end
	jz	list_done

	mov	cx,bx
	mov	di,dx
	repnz	scasw			; or until a match is found
	lodsw				; read each wchar_t (inc SI)
	jz	list_loop		; loop if match found

list_done:
	stc				; return(si-wcs-1)
	sbb	si,wcs
	mov	ax,si

if sizeD
	pop	ds
endif

cEnd				; Must NOT use <nogen>

% sEnd	CODE_SEG

	end
