	page	,132
	title	wcsstr - search for one string inside another
;***
;wcsstr.asm - search for one string inside another
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsstr() - search for one wchar_t string inside another
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcsstr(string1, string2) - search for wchar_t string2 in string1
;
;Purpose:
;	finds the first occurrence of wchar_t string2 in wchar_t string1
;
;Entry:
;	wchar_t *string1 - wchar_t string to search in
;	wchar_t *string2 - wchar_t string to search for
;
;Exit:
;	returns a pointer to the first occurrence of wchar_t string2 in
;	string1, or NULL if string2 does not occur in string1
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

labelP <PUBLIC,_fwcswcs>
cProc	_fwcsstr,<PUBLIC>,<si,di>

else

labelP <PUBLIC,wcswcs>
cProc	wcsstr,<PUBLIC>,<si,di>

endif

	parmDP	dst		; string1 = where to look
	parmDP	src		; string2 = what to look for

	localW	srclen

cBegin

if	sizeD
	push	ds		; Preserve DS
	les	di,(src)
	push	es
	pop	ds		; save (src) segment in DS
else
	push	ds
	pop	es		; ES = DS = DGROUP
	mov	di,(src)
endif

	xor	ax,ax		; Scan for null at end of (src)
	mov	cx,-1

	repnz	scasw
	not	cx
	dec	cx
	jcxz	empty_src	; src == "" ?
	dec	cx		; CX = wcslen(src)-1

	mov	(srclen),cx

if	sizeD
	les	di,(dst)
else
	mov	di,(dst)
endif
	mov	bx,di		; BX will keep the current offset into (dst)

	xor	ax,ax		; Scan for null at end of (dst)
	mov	cx,-1

	repnz	scasw
	not	cx
	dec	cx		; CX = wcslen(dst)

	mov	dx,cx		; Save wcslen(dst) in DX

	sub	dx,(srclen)	; DX = wcslen(dst) - (wcslen(src)-1)
	jbe	not_found	; wcslen(dst) <= (wcslen(src)-1)
				; target is longer than source?
	mov	di,bx		; restore ES:DI = (dst)

findnext:
	mov	si,word ptr (src)
	lodsw			; Get the first byte of the source
	mov	di,bx		; restore position in source
	mov	cx,dx		; count of possible starting bytes in src
;
;	CX, DX = number of bytes left in source where target can still fit
;	ES:DI, ES:BX = current position in (dst)
;	DS:SI = (src) + 1
;	AL = *(src)
;
	repne	scasw		; find next occurrence of *(target) in dst
	jne	not_found	; out of string -- return NULL

	mov	dx,cx		; update count of acceptable bytes left in dst
	mov	bx,di		; save current offset in dst

	mov	cx,(srclen)
	jcxz	match		; single wide-character src string?
	repe	cmpsw

	jne	findnext
;
; Match!  Return DS:(BX-1)
;
match:
	lea	ax,[bx-1]
if	sizeD
	mov	dx,es
endif
	jmp	short	retval

empty_src:	; empty src string, return dst (ANSI mandated)
if sizeD
	les	ax, (dst)
	mov	dx, es		; dx:ax = dest
else
	mov	ax, (dst)	; ax = dest
endif
	jmp	short retval	; return

not_found:
	xor	ax,ax
if	sizeD
	cwd
endif

retval:
if	sizeD
	pop	ds		; Restore DS
endif

	cEnd

% sEnd	CODE_SEG

	end
