/***
*wcsxfrm.c - Transform a wchar_t string using locale information
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Transform a wchar_t string using the locale information as set by
*   LC_COLLATE.
*
*******************************************************************************/

#include <string.h>
#include <locale.h>



/***
*size_t wcsxfrm() - Transform a wchar_t string using locale information
*
*Purpose:
*   Transform the wchar_t string pointer to by _wcs2 and place the
*   resulting wchar_t string into the array pointer to by _wcs1.
*   No more than _count wide characters are place into the
*   resulting wchar_t string (including the null).
*
*   The transformation is such that if wcscmp() is applied to
*   the two transformed wchar_t strings, the return value is equal to
*   the result of wcscoll() applied to the two original wchar_t strings.
*   Thus, the conversion must take the locale LC_COLLATE info
*   into account.
*
*   The value of the following expression is the size of the array
*   needed to hold the transformation of the source string:
*
*       1 + wcsxfrm(NULL,string,0)
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*   Thus, wcsxfrm() simply resolves to wcsncpy()/wcslen().
*
*Entry:
*   wchar_t *_wcs1       = result string
*   const wchar_t *_wcs2 = source string
*   size_t _count        = max wide chars to move
*
*   [If _count is 0, _wcs1 is permitted to by NULL.]
*
*Exit:
*   Length of the transformed wchar_t string (not including the terminating
*   null).  If the value returned is >= _count, the contents of the
*   _wcs1 array are indeterminate.
*
*Exceptions:
*
*******************************************************************************/

size_t _cdecl  wcsxfrm
    (
    wchar_t *_wcs1,
    const wchar_t *_wcs2,
    size_t _count
    )
{
    wcsncpy(_wcs1, _wcs2, _count);
    return(wcslen(_wcs2));
}
