/***
*asctime.c - convert date/time structure to ASCII string
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Contains asctime() - convert a date/time structure to ASCII string.
*
*******************************************************************************/

#include <time.h>
#include <register.h>
#include <internal.h>

/*  Day names must be Three character abbreviations strung together */

static char dnames[] = {
    "SunMonTueWedThuFriSat"
};

/*  Month names must be Three character abbreviations strung together */

static char mnames[] = {
    "JanFebMarAprMayJunJulAugSepOctNovDec"
};

#define _ASCBUFSIZE   26
static char near buf[_ASCBUFSIZE];

/*
** This prototype must be local to this file since the procedure is static
*  [Returns 'near' pointer except in multi-thread case.]
*/

#define _RETDIST_ near

static char _RETDIST_ * near pascal store_dt(char _RETDIST_ *, int);

/*
** store_dt is a local static function and is therefore declared "near"
*/

static char _RETDIST_ * near pascal store_dt(p, val)
REG1 char _RETDIST_ *p;
REG2 int val;
{
    *p++ = (char)('0' + val / 10);
    *p++ = (char)('0' + val % 10);
    return(p);
}


/***
*char *asctime(time) - convert a structure time to ascii string
*
*Purpose:
*   Converts a time stored in a struct tm to a charcater string.
*   The string is always exactly 26 characters of the form
*   Tue May 01 02:34:55 1984\n\0
*
*Entry:
*   struct tm *time - ptr to time structure
*
*Exit:
*   returns pointer to static string with time string.
*
*Exceptions:
*
*******************************************************************************/

char *  asctime(tb)
REG1 const struct tm *tb;
{
    REG2 char near *p = buf;
    int day, mon;
    int i;


    /* copy day and month names into the buffer */

    day = tb->tm_wday * 3;  /* index to correct day string */
    mon = tb->tm_mon * 3;   /* index to correct month string */
    for (i=0; i < 3; i++,p++) {
    *p = *(dnames + day + i);
    *(p+4) = *(mnames + mon + i);
    }

    *p = ' ';       /* blank between day and month  */

    p += 4;

    *p++ = ' ';
    p = store_dt(p, tb->tm_mday);   /* day of the month (1-31) */
    *p++ = ' ';
    p = store_dt(p, tb->tm_hour); /* hours (0-23) */
    *p++ = ':';
    p = store_dt(p, tb->tm_min);  /* minutes (0-59) */
    *p++ = ':';
    p = store_dt(p, tb->tm_sec);  /* seconds (0-59) */
    *p++ = ' ';

    p = store_dt(p, (1900 + tb->tm_year) / 100);    /* century */
    p = store_dt(p, (1900 + tb->tm_year) % 100);    /* year */

    *p++ = '\n';
    *p = '\0';

    return ((char *) buf);
}
