/***
*difftime.c - return difference between two times as a double
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Find difference between two time in seconds.
*
*******************************************************************************/

#include <sizeptr.h>

/* We must remove the difftime() prototype in compact and large Windows libs. */

#if !(defined(_WINDOWS) && sizeD)
#include <time.h>
#endif


/***
*double difftime(b, a) - find difference between two times
*
*Purpose:
*   returns difference between two times (b-a)
*
*   Multi-thread version must use pascal calling convention to be
*   re-entrant.
*
*Entry:
*   long a, b - times to difference (actually are time_t values)
*
*Exit:
*   returns a double with the time in seconds between two times
*
*Exceptions:
*
*******************************************************************************/

#if !(defined(_WINDOWS) && sizeD)

double  difftime(b,a)

time_t a;
time_t b;
{
    return( (double)b - (double)a );
}

#else   /* compact and large model Windows version */

extern double _near _fac;   /* make _fac near so we don't get a DGROUP fixup */

double * difftime( long b, long a )
{
    _fac = (double)b - (double)a;
    return( & _fac );
}

#endif  /* compact and large model Windows version */
