/***
*dos/ftime.c - return system time
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Returns the DOS date/time in a structure form.
*
*******************************************************************************/

#include <time.h>
#include <sys/timeb.h>
#include <dostypes.h>
#include <msdos.h>
#include <dos.h>
#include <internal.h>


/***
*void _ftime(timeptr) - return DOS time in a structure
*
*Purpose:
*   returns the current DOS time in a struct timeb structure
*
*Entry:
*   struct _timeb *timeptr - structure to fill in with time
*
*Exit:
*   no return value -- fills in structure
*
*Exceptions:
*
*******************************************************************************/

void _ftime(tp)
struct _timeb *tp;
{
    int yr, mon, day;
    _WINSTATIC struct _dosdate_t DosDate;
    _WINSTATIC struct _dostime_t DosTime;
    _WINSTATIC struct tm tb;

    __tzset();
    tp->timezone = (short)(_timezone / 60);

    /* get date from DOS
     */
    _dos_getdate(&DosDate);

    /* get time from DOS
     */
    _dos_gettime(&DosTime);

    /* If hours and minutes are both 0, get the date again (might have
     * passed midnight between date and time calls).
     */
    if ( (DosTime.hour == 0) && (DosTime.minute == 0) )
        _dos_getdate(&DosDate);

    tb.tm_year = (yr = DosDate.year - 1980) + 80;
    tb.tm_mday = day = DosDate.day;
    tb.tm_mon = (mon = DosDate.month) - 1;

    /* This will not always work outside of the range 1901 through 2099
     */
    tb.tm_yday = _days[tb.tm_mon] + day;
    if (!(yr & 3) && (mon > 2))
        tb.tm_yday ++;

    tb.tm_hour = DosTime.hour;

    tp->millitm = DosTime.hsecond * 10;
    tp->time = _dostotime_t(yr, mon, day, DosTime.hour, DosTime.minute,
    DosTime.second);

    tp->dstflag = _daylight && _isindst(&tb); /* Daylight Savings Time? */
}
