	page	,132
	title	strdate
;***
;strdate.asm - contains the function "_strdate()"
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	_strdate() stores the date in "MM/DD/YY" form in a user string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include msdos.inc
	.list

sBegin	CODE

	assumes cs,CODE

;***
;_strdate - return a static string containing the date in MM/DD/YY form
;
;Purpose:
;	_strdate() is a Quick C function which returns a static string
;	containing the date in the form "MM/DD/YY".
;
;	NOTE: This code supports dates from 1980 through 2079
;
;	char * _strdate(char * string);
;
;Entry:
;	char * string	Address of a 9-byte user buffer
;
;Exit:
;	Address of the input parameter in AX/DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;*******************************************************************************

cProc	_strdate,<PUBLIC>,<>

	parmDP	string

cBegin

	callos	getdate
if sizeD
	push	ds
	lds	bx,(string)
else
	mov	bx,(string)
endif
	sub	cx,2000 	; adjust century to range 0-99
	jnb	after_1999
	add	cx,100		; correct for years before 2000
after_1999:
	mov	ax,'/'
	mov	[bx+8],ah	; null terminator
	mov	[bx+2],al	; MM + `/' + DD
	mov	[bx+5],al	; DD + `/' + YY

	mov	al,dh
	cbw
	mov	ch,10
	div	ch
	add	ax,'0' + ('0' shl 8)
	mov	[bx],ax
	mov	al,dl
	cbw
	div	ch
	add	ax,'0' + ('0' shl 8)
	mov	[bx+3],ax
	mov	al,cl
	xor	ah,ah
	div	ch
	add	ax,'0' + ('0' shl 8)
	mov	[bx+6],ax

	xchg	ax,bx		; shorter than "mov ax,bx"
if sizeD
	mov	dx,ds
	pop	ds
endif

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
