	page	,132
	title	strtime
;***
;strtime.asm - contains the function "_strtime()"
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	_strtime() stores the time in "HH:MM:SS" form in a user string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include msdos.inc
	.list

sBegin	CODE

	assumes cs,CODE

;***
;char *_strtime() - return a static string containing the time in HH:MM:SS form
;
;Purpose:
;	_strtime() is a function which returns a static string
;	containing the time in the form "HH:MM:SS", using a 24 hr clock.
;
;Entry:
;	char * string - Address of a 9-byte user buffer
;
;Exit:
;	Address of the input parameter in AX/DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;*******************************************************************************

cProc	_strtime,<PUBLIC>,<>

	parmDP	string

cBegin

	callos	gettime
if sizeD
	push	ds
	lds	bx,(string)
else
	mov	bx,(string)
endif
	mov	ax,':'
	mov	[bx+8],ah	; null terminator
	mov	[bx+2],al	; HH + `:' + MM
	mov	[bx+5],al	; MM + `:' + SS

	mov	al,ch
	cbw
	mov	ch,10
	div	ch
	add	ax,'0' + ('0' shl 8)
	mov	[bx],ax
	mov	al,cl
	cbw
	div	ch
	add	ax,'0' + ('0' shl 8)
	mov	[bx+3],ax
	mov	al,dh
	cbw
	div	ch
	add	ax,'0' + ('0' shl 8)
	mov	[bx+6],ax

	xchg	ax,bx		; shorter than "mov ax,bx"
if sizeD
	mov	dx,ds
	pop	ds
endif

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
