	page	,132
	title	time - get system time
;***
;time.asm - DOS get time, return it in internal (time_t) form
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines time() - gets the DOS time and converts it to internal time.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include msdos.inc
.list

externP _dostotime_t		; DOS-to-internal time conversion

sBegin	code
	assumes cs,code

page
;***
;time_t time(time_t *timeptr) - get date/time from DOS
;
;Purpose:
;	Gets the current date and time and stores it in the time_t format.
;	The time is returned and stored via the pointer passed in timeptr.
;	If timeptr == NULL, the time is only returned, not stored in *timeptr.
;
;	The internal time format (time_t) is the number of seconds since
;	00:00:00, 01-01-70, UTC (this is the same as XENIX/UNIX/POSIX format).
;
;Entry:
;	timeptr - pointer to a time_t to store time in.
;
;Exit:
;	returns the current time.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	time,<PUBLIC>,<si>

	parmDP	arg1

cBegin
	callos	getdate
	mov	bx,dx		; save date in bx for test in case of date
				; changing between GetTime and GetDate calls.
	mov	si,cx		; save year for same reason

	callos	gettime
	mov	ah,0
	mov	al,dh
	push	ax		; push seconds
	mov	al,cl
	push	ax		; push minutes
	mov	al,ch
	push	ax		; push hours

	push	ax		; save hours for test

	callos	getdate
	cmp	bx,dx		; has date changed?
	pop	ax		; recover hours for test

	je	dateok		; date hasn't changed all o.k.
	cmp	al,23		; is the first getdate valid?
	jne	dateok		; no, use the second already in dx

	mov	dx,bx		; yes, use the first getdate.
	mov	cx,si		; get old year

dateok:
	mov	ah,0
	mov	al,dl		; push day
	push	ax
	mov	al,dh
	push	ax		; push month
	sub	cx,1980
	push	cx		; push year
	call	_dostotime_t	; _dostotime_t(yr,mo,dy,hr,mn,sc)
	add	sp,12

if	sizeD			; test if tloc = 0
	cmp	word ptr (arg1+2),0
else
	cmp	arg1,0
endif
	je	timret		;   yes - return

if	sizeD			;   no - store return value
	les	bx,arg1
	mov	es:[bx+2],dx	; high word
	mov	es:[bx],ax	; low word
else
	mov	bx,arg1
	mov	[bx+2],dx	; high word
	mov	[bx],ax 	; low word
endif

timret:
cEnd	nolocals		; quicker stack clean-up

sEnd
	end
