/***
*utime.c - set modification time for a file
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Sets the access/modification times for a file.
*
*******************************************************************************/

#include <time.h>
#include <sys/utime.h>
#include <msdos.h>
#include <dostypes.h>
#include <fcntl.h>
#include <io.h>
#include <register.h>
#include <dos.h>
#include <errno.h>
#include <stddef.h>
#include <internal.h>



/***
*int _utime(pathname, time) - set modification time for file
*
*Purpose:
*   Sets the modification time for the file specified by pathname.
*   Only the modification time from the utimbuf structure is used
*   under MS-DOS.
*
*Entry:
*   struct _utimbuf *time - new modification date
*
*Exit:
*   returns 0 if successful
*   returns -1 and sets errno if fails
*
*Exceptions:
*
*******************************************************************************/

int _utime (
    const char *fname,
    struct _utimbuf *times
    )
{
    REG1 struct tm *tmb;
    REG2 unsigned int dos_date = 0;
    REG3 unsigned int dos_time = 0;
    int fh;
    _WINSTATIC time_t timeval;
    _WINSTATIC union _REGS inregs;

    /* get value of time to be used and convert it to local time */

    if (times == NULL)
        time(&timeval);
    else
        timeval = times->modtime;

    if ((tmb=localtime(&timeval)) == NULL) {
        errno = EINVAL;
        return(-1);
    }

    /* open file, fname, since filedate system call needs a handle.  Note
     * utime definition says you must have write permission for the file
     * to change its time, so open file for write only.  Also, must force
     * it to open in binary mode so we dont remove ^Z's from binary files.
     */

    if ((fh = inregs.x.bx = _open(fname, _O_WRONLY|_O_BINARY)) < 0)
        return(-1);

    /* put together the DOS date and time values from the struct returned
     * from localtime
     */

    SET_DOS_YEAR(dos_date, tmb->tm_year - 80);
    SET_DOS_MONTH(dos_date, tmb->tm_mon + 1);
    SET_DOS_DAY(dos_date, tmb->tm_mday);
    SET_DOS_HOUR(dos_time, tmb->tm_hour);
    SET_DOS_MIN(dos_time, tmb->tm_min);
    SET_DOS_SEC(dos_time, tmb->tm_sec / 2);

    /* set the date via the filedate system call, close the file and
     * return.  Note we don't need to check the return value from either
     * the set file date call or the close since we can't fail either of
     * them.  The set file date call can fail only if the file handle is
     * bad (we would have failed and returned at the open), or we pass
     * some value other than 0/1 in al, which we don't.  The close can
     * only fail if the file handle is bad, which, by the same argument
     * given above, it can't be.
     */

    inregs.x.cx = dos_time;
    inregs.x.dx = dos_date;
    inregs.h.al = 1;
    inregs.h.ah = DOS_filedate;
    _intdos(&inregs,&inregs);

    _close(fh);
    return(0);
}
