/***
*dtoxtime.c - convert broken down time values to Xenix time value
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines _dostotime_t() - convert DOS time to calendar time (time_t
*   value)
*
*******************************************************************************/

#include <time.h>
#include <ctime.h>
#include <register.h>
#include <internal.h>


/***
*time_t _dostotime_t(yr, mo, dy, hr, mn, sc) - convert time to calendar time
*   in time_t format.
*
*Purpose:
*   Converts a DOS time value to calendar time time_t format. That is,
*   the number elapsed seconds since 01-01-70, 00:00:00, UTC.
*
*Entry:
*   int yr, mo, dy -    date (yr is based on 1980)
*   int hr, mn, sc -    time
*
*Exit:
*   Returns calendar time value.
*
*Exceptions:
*
*******************************************************************************/

time_t _dostotime_t(REG1 int yr, int mo, int dy, int hr, int mn, int sc)
{
    _WINSTATIC struct tm tb;
    REG2 int mdays;
    unsigned long caltim;

    /*
     * Calculate day of year (minus one). The test for a leap year is no
     * good beyond the year 2099 (and depends on yr being based on leap
     * year, 1980).
     */
    mdays = _days[mo - 1];
    if ( !(yr & 3) && (mo > 2) )
        mdays++;

    /*
     * Calculate calendar time value (elapsed seconds since 01-1-1970,
     * 00:00:00). Note again that yr is based on 1980. Also note that
     * to compute elapsed leap years, the base is shifted to '76 and
     * 2 is added to the result ('72 and '76 were leap years).
     */
    caltim = ((((yr + 10L) * 365L + ((yr + 3) >> 2) + 2L + dy + mdays)
         * 24L + (long)hr) * 60L + (long)mn) * 60L + (long)sc;

    /*
     * Account for time zone.
     */
    __tzset();
    caltim += _timezone;

    /*
     * Fill in enough fields of tb struct for _isindst(), then call it to
     * determine DST.
     */
    tb.tm_yday = mdays + dy;
    tb.tm_year = yr + 80;
    tb.tm_mon = mo - 1;
    tb.tm_hour = hr;
    if (_daylight && _isindst(&tb))
        caltim -= 3600L;
    return(caltim);
}
