/***
*systime.c - _getsystime and _setsystime
*
*   Copyright (c) 1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines _getsystime() and _setsystime()
*
*******************************************************************************/

#ifdef DOS
#include <dos.h>
#endif
#include <time.h>

/***
*unsigned _getsystime(timestruc, milliseconds) - Get current system time
*
*Purpose:
*
*Entry:
   struct tm * ptm - time structure
*
*Exit:
*   milliseconds of current time
*
*Exceptions:
*
*******************************************************************************/

unsigned _getsystime(struct tm * ptm)
{
#ifdef DOS

    union _REGS r;

    r.h.ah = 0x2a;
    _intdos(&r, &r);

    ptm->tm_mday    = (int)r.h.dl;
    ptm->tm_mon     = (int)r.h.dh - 1;
    ptm->tm_year    = (int)r.x.cx - 1900;
    ptm->tm_wday    = (int)r.h.al;

    r.h.ah = 0x2c;
    _intdos(&r, &r);

    ptm->tm_sec     = (int)r.h.dh;          // 0-59
    ptm->tm_min     = (int)r.h.cl;          // 0-59
    ptm->tm_hour    = (int)r.h.ch + 1;      // 0-23

    // Normalize uninitialized fields.
    mktime(ptm);

    return (r.h.dl * 100);

#else

#endif

}

/***
*unsigned _setsystime(timestruc, milliseconds) - Set new system time
*
*Purpose:
*
*Entry:
*   struct tm * ptm - time structure
*   unsigned milliseconds - milliseconds of current time
*
*Exit:
*   0 if succeeds
*   system error if fails
*
*Exceptions:
*
*******************************************************************************/

unsigned _setsystime(struct tm * ptm, unsigned uMilliseconds)
{
#ifdef DOS
    union _REGS r;

    // Normalize uninitialized fields.
    mktime(ptm);

    r.h.ah  = 0x2d;
    r.h.ch  = (unsigned char)(ptm->tm_hour) - 1;
    r.h.cl  = (unsigned char)ptm->tm_min;
    r.h.dh  = (unsigned char)ptm->tm_sec;
    r.h.dl  = (unsigned char)(uMilliseconds / 100);
    _intdos(&r, &r);
    if (r.h.al == 0xff) {
    return (0xffff);
    }

    r.h.ah  = 0x2b;
    r.x.cx  = (unsigned short)(ptm->tm_year + 1900);
    r.h.dh  = (unsigned char)(ptm->tm_mon + 1);
    r.h.dl  = (unsigned char)ptm->tm_mday;
    _intdos(&r, &r);
    if (r.h.al == 0xff) {
    return (0xffff);
    }

    return (0);

#else

#endif

}
