	page	,132
	title	_cinittm - Set initial time
;***
;_cinittm.asm - Set initial time
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	This routine is necessary for the startup code to save the
;	initial process startup time.  This is needed to support the
;	clock runtime functionality (which returns elapsed time of
;	the calling process).
;
;	(1) The clock runtime code accesses the variable _citime.
;	_citime is in the current module and forces _cinittm to be
;	linked into the program.
;	(2) _cinittm, in turn, puts the function name "_inittime" into
;	the startup action table.  Thus, _inittime will be executed at
;	process startup time.
;	(3) Inittime, in turn, gets and saves the initial process startup
;	time.  Thus, clock can later refer to this initial time value.
;
;*******************************************************************************

?DF	=	1		; tell cmacros.inc we want to define our own segments

include version.inc
.xlist
include cmacros.inc
include defsegs.inc
.list

CrtDefSegs <code, data>
CrtDefSegs <xiseg>

page

sBegin	data
assumes ds,data

globalW _citime,0

sEnd


externP _inittime

sBegin	xiseg

if	sizeC
	dd	_inittime
else
	dw	_inittime
endif

sEnd


	end
