/*
 * Turbo Vision example of a modified TInputLine that parses input as it
 * is entered.  This line allows only a range of characters to be passed,
 * the range specified in the constructor and defaulting to numeric digits
 * '0'-'9'.
 */

  ------------------------------------------------------------------------
   The following example routines have been provided by the Technical
   Support staff at Borland International.  They are provided as a
   courtesy and not as part of a Borland product, and as such, are
   provided without the assurance of technical support or any specific
   guarantees.

  ========================================================================
    Copyright (c) 1991 by Borland International
    All Rights Reserved.



#define Uses_TEvent
#define Uses_TInputLine
#include <tv.h>

#include <ctype.h>
#pragma hdrstop

class TBitLine : public TInputLine
{

public:

    TBitLine(TRect& bounds, int aMaxLen, char low = '0', char high = '9') :
        TInputLine(bounds, aMaxLen)
    {
        lowDigit = low; highDigit = high;
    }
    virtual void handleEvent(TEvent& event);

private:

    char lowDigit, highDigit;

};

void TBitLine::handleEvent(TEvent& event)
{
    char key = event.keyDown.charScan.charCode;

    if( !(event.what == evKeyboard && isprint(key) &&
          (key < lowDigit || key > highDigit)) )
        TInputLine::handleEvent(event);
}
