#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include "txarray.h"


/*
	Define a class called anything as an example of caching arrays of a
	class
*/

class anything
{
public:
	int colour_of_socks;
	char name[10];
	int age;
	float cash;
};


/*
	xarray <class or type> <variable name>(size)
	is the way to make a class or type an extended array.
*/


#define any 30000
void do_anything()
{
	xarray<anything> me(any);
	int i;
	printf ("Anything is a class of size %d bytes\n",sizeof (anything));
	printf ("The following test is on an array of anything\n");
	printf ("The array has %ld elements\n", (long) any);
	printf ("Press any key to begin the test\n");
	getch();
	start_timer();
	printf ("Making Anything\n");
	for (i=0;i<=any;i++)
	{
		me[i].colour_of_socks=i;
		sprintf (me[i].name,"%d",i);
		me[i].age=2*i;
		me[i].cash=5.5*(float)i;
	}
	printf ("Checking anything\n");
	for (i=0;i<=any;i++)
	{
		if (me[i].colour_of_socks!=i) goto ER;
		if (me[i].age!=2*i) goto ER;
		if (me[i].cash!=5.5*(float)i) goto ER;
//		printf ("%s ",me[i].name);
	}
	printf ("\n");
	stop_timer();
	return;
ER:
	printf ("Error checking anything\n");
}

void fillaaarray();

void fillxxfloatarray (int x, int y, xxarray<float> arr, int a)
{
	long i,j;
	for (i=0;i<x;i++)
	{
		for (j=0;j<y;j++)
		{
			arr[i][j]=i*180+j+a;
		}
	}
}

/* Global floating point arrays */
xxarray<double> aa;
xxarray<float> bb;


void accumulate (xarray<float> arr, int x)
{
	int i;
	float j=0;
	for (i=0;i<x;i++) j+=arr[i];
	printf ("Addition of all elements in the column is %f\n",j);
}

void atest ()
{
	long i,j,l;
	/*Declaring two dimensional floating arrays,
			=>   xxarray<float> <variable>(<x size>,<y size>); */
	xxarray<float> cc(180,180);//, dd (360,180);
	/*Constructing global two dimensional arrays*/
	/* These constructed two dimensional arrays will not go out of
		scope so will need to be destroyed explictly to free memory */
	bb.construct(180,180);
	aa.construct(180,180);
	/*Declaring one dimensional floating arrays,
			=>	xarray<float> <variable>(<size>);  */
	xarray<float> a(65000);//, b(65000), c(65000) ,d(65000);
	printf ("\nThe following test checks three arrays of the size that will\n");
	printf ("be shown. Array aa and bb are global arrays. aa is tested\n");
	printf ("via a separate module\n");
	printf ("Press a key to check arrays\n");
	getch();
	start_timer();
	printf ("Filling Arrays\n");
	printf ("double array aa(180,180)\n");
	fillaaarray();
	printf ("bb(180,180)\n");
	fillxxfloatarray (180,180,bb,1);
	printf ("cc(180,180)\n");
	fillxxfloatarray (180,180,cc,2);
//	printf ("dd(360,180)\n");
//	fillxxfloatarray (360,180,dd,3);
	printf ("Checking Arrays\n");
	printf ("double array aa(180,180)\n");
	for (i=0;i<180;i++)
	{
		for (j=0;j<180;j++)
		{
			if (aa[i][j]!=i*180+j) goto ERR2;
		}
	}
	printf ("bb(180,180)\n");
	for (i=0;i<180;i++)
	{
		for (j=0;j<180;j++)
		{
			if (bb[i][j]!=i*180+j+1) goto ERR2;
		}
	}
	printf ("cc(180,180)\n");
	for (i=0;i<180;i++)
	{
		for (j=0;j<180;j++)
		{
			if (cc[i][j]!=i*180+j+2) goto ERR2;
		}
	}
/*	printf ("dd(360,180)\n");
	for (i=0;i<360;i++)
	{
		for (j=0;j<180;j++)
		{
			if (dd[i][j]!=i*180+j+3) goto ERR2;
		}
	}*/
	stop_timer();
/*
	An example of passing a column of array cc,
	cc is of type xxfloat,
	cc[10] is of type xfloat
*/
	printf ("passing column 10 of cc array to accumulate routine\n");
	accumulate (cc[10],180);
	printf ("\nThe following test checks an array size 65000\n");
	printf ("Press any key to start the test\n");
	getch();
	start_timer();
	printf ("Filling Arrays\n");
	printf ("a(65000)\n");
	for (i=0;i<65000;i++)
	{
		a[i]=(float)i;
	}
/*	printf ("b(65000)\n");
	for (i=0;i<65000;i++)
	{
		b[i]=(float)i;
	}
	printf ("c(65000)\n");
	for (i=0;i<65000;i++)
	{
		c[i]=(float)i;
	}
	printf ("d(65000)\n");
	for (i=0;i<65000;i++)
	{
		d[i]=(float)i;
	}*/
	printf ("Checking Arrays\n");
	printf ("a(65000)\n");
	for (i=0;i<65000;i++)
	{
		if (a[i]!=i) goto ERR;
	}
/*	printf ("b(65000)\n");
	for (i=0;i<65000;i++)
	{
		if (b[i]!=i) goto ERR;
	}
	printf ("c(65000)\n");
	for (i=0;i<65000;i++)
	{
		if (c[i]!=i) goto ERR;
	}
	printf ("d(65000)\n");
	for (i=0;i<65000;i++)
	{
		if (d[i]!=i) goto ERR;
	}*/
	stop_timer();
	aa.destroy();
	bb.destroy();
	return;
ERR:
	printf ("Error in large array %ld %f\n",i,a[i]);
	exit(-1);

ERR2:
	printf ("Error in 2d array %ld, %ld, %f, %f \n",i,j,aa[i][j],(float)(i*180+j));
}

#define SZ 983040L

void btest()
{
	long i,j,l;
	xarray<char> huge_array(SZ);
	printf ("Memory available %ld\n",coreleft());
	printf ("\nThe following test checks and arrays of size %ld bytes\n",SZ);
	printf ("Press a key to test the huge array\n");
	getch();
	start_timer();

	printf ("Filling huge array\n");
	for (i=0;i<SZ;i++)
		huge_array[i]=(char)i;
	printf ("Checking huge array\n");
	for (i=0;i<SZ;i++)
		if (huge_array[i]!=(char)i) goto ERR;
	printf ("hugh array ok\n");
	stop_timer();
	return;
ERR:
	printf ("Error in hugh array");
	exit(-1);
}

void main()
{

/* Declared to work with restricted version */
	 __block_size=65536;
	 __blocks=16;

	long i,j,l;
	printf ("Memory available %ld\n",coreleft());
	do_anything();
	atest();
	btest();
	printf ("Tests finished press any key to stop the program\n");
	getch();
}