#include "memory.h"
#include <dos.h>

unsigned MaxEmsPages = 0;

int EmsMemory::isInitialized = 0;
EmsMemory *EmsMemory::head = 0;
long EmsMemory::lastAddr = 0;
unsigned EmsMemory::handle = 0;
char EmsMemory::framePageInUse[EMSPAGESPERFRAME] = { 0,0,0,0 };
unsigned EmsMemory::frameSeg = 0;

void ClearEms()
	{
	if( EmsMemory::handle != 0 )
		{
		_DX = EmsMemory::handle;
		_AH = 0x45;
		geninterrupt(0x67);
		}
	}

#pragma exit ClearEms

EmsMemory::EmsMemory()
	{
	init();
	}

EmsMemory::EmsMemory( size_t sz )
	{
	init();
	allocate(sz);
	}

EmsMemory::~EmsMemory()
	{
	free();
	}

int EmsMemory::allocate( size_t sz )
	{
	if( handle == 0 || memsize != 0 || sz == 0 )
		return 0;
	memsize = 0;
	long aAddr = 0;
	EmsMemory *parent = head;
	if( head == 0 )
		{
		if( sz > lastAddr )
			return 0;
		}

	else
		{
		while( parent->next != 0 )
			{
			aAddr = parent->addr + parent->memsize;
			if( fitsInto( aAddr, parent->next->addr, sz) )
				break;
			parent = parent->next;
			}
		if( parent->next == 0 )
			{
			aAddr = parent->addr+parent->memsize;
			if( !fitsInto( aAddr, lastAddr, sz) )
				aAddr = -1L;
			}

		if( aAddr < 0 )
			{
			for( parent = head; parent->next != 0; parent = parent->next )
				{
				aAddr = nextPageAddr( parent->addr+parent->memsize );
				if( fitsInto(aAddr, parent->next->addr, sz) )
					break;
				}
			if( parent->next == 0 )
				{
				aAddr = nextPageAddr( parent->addr+parent->memsize );
				if( !fitsInto(aAddr, lastAddr, sz) )
					return 0;
				}
			}
		}

	if( parent == 0 )
		{
		next = 0;
		head = this;
		}
	else
		{
		next = parent->next;
		parent->next = this;
		}
	addr = aAddr;
	memsize = sz;
	return sz;
	}

void EmsMemory::free()
	{
	EmsMemory *ptr;

	if( memsize == 0 || lockflag != 0 )
		return;

	if( head == this )
		head = head->next;
	else
		for( ptr = head; ptr->next; ptr = ptr->next )
			if( ptr->next == this )
				{
				ptr->next = ptr->next->next;
				break;
				}
	addr = 0;
	next = 0;
	memsize = 0;
	}

void far *EmsMemory::lock()
	{
	if( memsize == 0 )
		return 0;

	if( !lockflag )
		{
		unsigned st = pageOf(addr);
		unsigned end = pageOf( nextPageAddr(addr+memsize) );
		framePage = availableFramePage(end-st);
		if( framePage < 0 || framePage >= EMSPAGESPERFRAME )
			return 0;
		mapPagesToFrame( framePage, st, end-st );
		}
	lockflag++;
	return (char far *)framePageAddr(framePage)+(addr-pageAddr(pageOf(addr)));
	}

void EmsMemory::unlock()
	{
	if( !lockflag )
		return;

	lockflag--;
	if( lockflag == 0 )
		{
		unsigned st = pageOf(addr);
		unsigned end = pageOf( nextPageAddr(addr+memsize) );
		unmapFramePages( framePage, end-st );
		}
	}

long EmsMemory::memAvail()
	{
	if( handle == 0 )	return 0;
	long l = lastAddr;
	EmsMemory *ptr;

	for( ptr = head; ptr != 0; ptr = ptr->next )
		l -= ptr->memsize;
	return l;
	}

long EmsMemory::maxAvail()
	{
	if( handle == 0 )	return 0;
	long tmp, l = 0;
	EmsMemory *ptr;

	if( head == 0 )
		l = lastAddr;
	else
		{
		for( ptr = head; ptr->next != 0; ptr = ptr->next )
			{
			tmp = ptr->next->addr - ptr->addr - ptr->memsize;
			if( tmp > l )
				l = tmp;
			}
		tmp = lastAddr - ptr->addr - ptr->memsize;
		if( tmp > l )
			l = tmp;
		}
	return l;
	}

void EmsMemory::init()
	{
	unsigned pages;

	if( !isInitialized )
		{
		isInitialized++;
		if( getvect(0x67) == 0 )
			return;
		_AH = 0x40;
		geninterrupt(0x67);
		if( _AH )
			return;
		_AH = 0x41;
		geninterrupt(0x67);
		if( _AH )
			return;
		frameSeg = _BX;
		pages = MaxEmsPages;
		if( pages < 4 )
			{
			_AH = 0x42;
			geninterrupt(0x67);
			pages = _BX;
			}
		if( pages < 4 )
			return;
		_BX = pages;
		_AH = 0x43;
		geninterrupt(0x67);
		if( _AH )	return;
		handle = _DX;
		lastAddr = (long)pages * EMSPAGESIZE;
		}
	}

int EmsMemory::fitsInto( long addr, long next, size_t sz )
	{
	if( next <= addr || next-addr < sz )
		return 0;
	unsigned st = pageOf(addr);
	unsigned end = pageOf(addr+sz-1);
	if( end-st+1 > EMSPAGESPERFRAME )
		return 0;
	return 1;
	}

long EmsMemory::nextPageAddr( long addr )
	{
	long l = (long)pageOf(addr)*EMSPAGESIZE;
	if( l < addr )
		l += EMSPAGESIZE;
	return l;
	}

unsigned EmsMemory::pageOf( long addr )
	{
	return (unsigned)(addr / EMSPAGESIZE);
	}

long EmsMemory::pageAddr( unsigned page )
	{
	return (long)page * EMSPAGESIZE;
	}

char EmsMemory::availableFramePage( char count )
	{
	if( count < 1 || count > EMSPAGESPERFRAME || handle == 0 )
		return -1;
	char st, i;
	st = 0;
	while( st < EMSPAGESPERFRAME )
		{
		for( i = 0; i < count && st+i < EMSPAGESPERFRAME; i++ )
			if( framePageInUse[st+i] != 0 )
				break;
		if( i >= count )
			break;
		}
	if( st >= EMSPAGESPERFRAME )
		st = -1;
	return st;
	}

void EmsMemory::mapPagesToFrame( char st, unsigned page, char count )
	{
	if( st < 0 || count < 0 || st+count > EMSPAGESPERFRAME || handle == 0 )
		return;
	while(count)
		{
		_DX = handle;
		_BX = page;
		_AL = st;
		_AH = 0x44;
		geninterrupt(0x67);
		framePageInUse[st++] = 1;
		page++;
		count--;
		}
	}

void far *EmsMemory::framePageAddr( char page )
	{
	if( handle == 0 )
		return 0;
	else
		return MK_FP( frameSeg+1024*(unsigned)page, 0 );
	}

void EmsMemory::unmapFramePages( char st, char count )
	{
	if( handle == 0 )
		return;

	while(count)
		{
		if( framePageInUse[st] )
			{
			_DX = handle;
			_BX = 0xFFFF;
			_AL = st;
			_AH = 0x44;
			geninterrupt(0x67);
			framePageInUse[st++] = 0;
			}
		count--;
		}
	}
