#include "memory.h"

int VMemManager::allocScheme = ConvEmsDisk;

MemoryObject *VMemManager::allocate( size_t sz )
	{
	MemoryObject *mem;

	if( sz == 0 )	return 0;

	if( allocScheme == ConvEmsDisk || allocScheme == ConvDiskEms )
		mem = new ConvMemory(sz);
	else if( allocScheme == EmsConvDisk || allocScheme == EmsDiskConv )
		mem = new EmsMemory(sz);
	else
		mem = new DiskMemory(sz);

	if( mem != 0 && mem->memSize() == sz )
		return mem;
	delete mem;

	if( allocScheme == EmsConvDisk || allocScheme == DiskConvEms )
		mem = new ConvMemory(sz);
	else if( allocScheme == ConvEmsDisk || allocScheme == DiskEmsConv )
		mem = new EmsMemory(sz);
	else
		mem = new DiskMemory(sz);

	if( mem != 0 && mem->memSize() == sz )
		return mem;
	delete mem;

	if( allocScheme == EmsDiskConv || allocScheme == DiskEmsConv )
		mem = new ConvMemory(sz);
	else if( allocScheme == ConvDiskEms || allocScheme == DiskConvEms )
		mem = new EmsMemory(sz);
	else
		mem = new DiskMemory(sz);

	if( mem != 0 && mem->memSize() == sz )
		return mem;
	delete mem;
	return 0;
	}
