#define STRICT
#define WIN31
#include <owl.h>

class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
	: TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

class TMyWindow : public TWindow
{
public:
	TMyWindow( PTWindowsObject, LPSTR );
	~TMyWindow();
	virtual void SetupWindow();
	virtual void ShutDownWindow();
	virtual void Paint( HDC , PAINTSTRUCT _FAR &);
	virtual LPSTR GetClassName();
	virtual void GetWindowClass( WNDCLASS _FAR & );
	virtual void WMLButtonDown( RTMessage ) = [ WM_FIRST + WM_LBUTTONDOWN ];
  virtual void WMQueryOpen( RTMessage ) = [ WM_FIRST + WM_QUERYOPEN ];
};

void TMyWindow::WMQueryOpen( RTMessage msg ) {
	msg.Result = 0;
}

TMyWindow::TMyWindow( PTWindowsObject p, LPSTR s ) : TWindow( p, s )
{
	Attr.ExStyle |= WS_EX_TOPMOST;
}

TMyWindow::~TMyWindow()
{
}

void TMyWindow::Paint( HDC , PAINTSTRUCT _FAR & )
{
}


void TMyWindow::SetupWindow()
{
	TWindow::SetupWindow();
}

void TMyWindow::ShutDownWindow()
{
	TWindow::ShutDownWindow();
}

LPSTR TMyWindow::GetClassName()
{
	return "MYWINDOW";
}
void TMyWindow::GetWindowClass( WNDCLASS _FAR & wc )
{
    TWindow::GetWindowClass( wc );
}

void TMyWindow::WMLButtonDown( RTMessage )
{
	DWORD dw = GetWindowLong( HWindow , GWL_EXSTYLE );
  if ( dw & WS_EX_TOPMOST )
  	MessageBox( HWindow , "we have topmost" , "", MB_OK );
}

void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("Sample ObjectWindows Program", hInstance, hPrevInstance,
			   lpCmdLine, SW_SHOWMINIMIZED );
  MyApp.Run();
  return MyApp.Status;
}
