#define STRICT
#define WIN31

#include <owl.h>
#include <combobox.h>
#include <listbox.h>
#include <edit.h>


#define     WM_SHOWDIALOG   100

_CLASSDEF( TApp )
_CLASSDEF( TMainWindow )
_CLASSDEF( TLitDialog )



char *Names[]   = { "Andromaque", 
                    "Berenice", 
                    "Corneille",
                    "Desdemone",  
                    "Eloise", 
                    "Flaubert",
                    "Gustave",  
                    "Hugo" 
                  };

char *Oeuvres[] = { "de Racine", 
                    "Encore Racine", 
                    "Le Cid",
                    "Shakespeare", 
                    "de Rousseau", 
                    "Mme Bovary",
                    "en sais plus", 
                    "Les Miserables" 
                  };

char *Language[]= { "C",
                    "C++",
                    "Pascal",
                    "Assembler", 
                    "Modula", 
                    "Cobol",
                    "Smalltalk", 
                    "Simula-67" 
                  };




class TApp : public TApplication
{
    public:
        TApp( LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
              LPSTR lpCmdLine, int nCmdShow) :
        TApplication(AName, hInstance, hPrevInstance,
                      lpCmdLine, nCmdShow)
        {};
        virtual void InitMainWindow();
};



struct xferBuff
{
    PTComboBoxData ComboData1;
    PTListBoxData  ListData1;
    PTComboBoxData ComboData2;
    char  EditText[255];
    PTListBoxData  ListData2;
};


class TMainWindow : public TWindow
{
        static char szClassName[];
    public:
        xferBuff  TLitDlgBuffer;

        TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                     PTModule AModule = NULL );
        virtual void GetWindowClass( WNDCLASS _FAR & AWndClass );
        virtual void SetupWindow();
        virtual void WMShowDialog( RTMessage msg ) =
                                 [ CM_FIRST + 100 ];
        LPSTR  GetClassName()
        {
            return( szClassName );
        }
};
char TMainWindow::szClassName[] = "!App!ClassName";



class TLitDialog : public TDialog
{
    public:
	    TLitDialog( PTWindowsObject, LPSTR, PTModule AModule = NULL );
};



void TApp::InitMainWindow()
{
    MainWindow = new TMainWindow( NULL, "Sample App" );
}



TMainWindow::TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                          PTModule AModule ):
TWindow( AParent, ATitle, AModule )
{
    AssignMenu( "MAINMENU" );

    TLitDlgBuffer.ComboData1 = new TComboBoxData;
    TLitDlgBuffer.ComboData2 = new TComboBoxData;
    TLitDlgBuffer.ListData1  = new TListBoxData;
    TLitDlgBuffer.ListData2  = new TListBoxData;
}



void TMainWindow::GetWindowClass( WNDCLASS _FAR & AWndClass )
{
    TWindow::GetWindowClass( AWndClass );
}



void TMainWindow::SetupWindow()
{
    TWindow::SetupWindow();
    lstrcpy( TLitDlgBuffer.EditText, "Some text - please change" );

    for( int i=0; i<sizeof( Names )/sizeof( Names[0] ); i++ )
    {
        TLitDlgBuffer.ComboData1->AddString( Names[i] );
        TLitDlgBuffer.ComboData2->AddString( Oeuvres[i] );
	    TLitDlgBuffer.ListData1->AddString( Language[i] );
        TLitDlgBuffer.ListData2->AddString( Language[i] );
    }
}



TLitDialog::TLitDialog( PTWindowsObject AParent, LPSTR AName,
                    PTModule AModule ):
TDialog( AParent, AName, AModule )
{
    xferBuff *buffptr;


    new TComboBox( this, 100, 0 );
    new TListBox ( this, 300 );
    new TComboBox( this, 200, 0 );
    new TEdit    ( this, 400, 255 );
    new TListBox ( this, 500 );

    buffptr = &(( PTMainWindow )Parent)->TLitDlgBuffer;

    TransferBuffer = buffptr;
}


void TMainWindow::WMShowDialog( RTMessage )
{
    PTLitDialog pd = new TLitDialog( this, "TESTDIALOG" );
    if ( pd )
    {
        if ( GetApplication()->ExecDialog( pd ) == IDOK )
        {
            static char szMsg[150];
            wsprintf( szMsg, "> %s \n> %s",
                      ( LPSTR )TLitDlgBuffer.ComboData1->Selection,
                      ( LPSTR )TLitDlgBuffer.ComboData2->Selection );
            MessageBox( HWindow, szMsg, "List Selections", MB_OK );
        }
    }
}



int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow)
{
    TApp App ( "Sample App", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
    App.Run();
    return( App.Status );
}
