ideal
locals
jumps
p386
model huge
stack 100h

LoopDemo = 0            ;set to 1 to loop text, 0 to quit upon reaching end
NumLenses = 500
ScrollDelayInit = 2
VerticalSpacing = 6


segment     Code
            assume cs:Code
;
struc       LensType
            Active db 0
            X dw 0
            Y dw 0
ends        LensType
;
include     "palette.inc"
include     "lens.inc"
include     "antique.dmp"
include     "sinewave.inc"
SineWavePos dw 0
LensTable   LensType NumLenses DUP (<>)
CurPalette  db 256 dup (0,0,0)
label       ScrollText byte
            db "Whoa!  Isn't this a neat effect?  ""Not really,"" you say?  "
            db "True, but I'm starting to run out of ideas.  In case you "
            db "haven't noticed, each sphere is actually a magnifying glass "
            db "that uses the technique that I described in CSIPD.  Well, "
            db "I know this is getting boring so I'll make this section "
            db "end here...        ",0
ScrollPos   dw 0                ;moves from 0 to number of chars in ScrollText
ScrollCol   db 7                ;moves from 7 to 0
ScrollDelay dw ScrollDelayInit  ;moves from ScrollDelayInit to 0
;
proc        Start
            ;**** fade the screen to black ****
            call fade_out

            ;**** switch over to graphics mode ****
            mov ax,0013h
            int 10h

            ;**** set the palette to all black ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            mov cx,256
            xor al,al
            SetPalette

            ;**** convert the image and display it ****
            mov ax,ImageSegment
            mov ds,ax
            mov si,offset ImageOffset+18
            call Fix_TGA_palette
            mov si,offset ImageOffset+18+768
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200)/4
            cld
            rep movsd

            ;**** fade in the image ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            mov ax,ImageSegment
            mov es,ax
            mov di,offset ImageOffset+18
            call fade_in
            ;-----------------------------------------------------------------
            mov [cs:ScrollDelay],ScrollDelayInit

@@MainLoop: ;**** copy the background into our work buffer ****
            mov ax,ImageSegment
            mov ds,ax
            mov si,offset ImageOffset+18+768
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            mov cx,(320*200)/4
            cld
            rep movsd

            ;**** put it under the lens ****
            mov cx,NumLenses                ;CX = number of lenses to do
            mov si,offset LensTable         ;CS:SI ==> current lens
            mov bx,[cs:SineWavePos]         ;\
            dec bx                          ; \
            and bx,SineWaveLength - 1       ;  > get a sinewave pointer
            mov [cs:SineWavePos],bx         ; /
            shl bx,1                        ;/
@@DoLenses: cmp [cs:si+LensType.Active],0   ;\ make sure that this lens
            jz @@NextLens                   ;/ is active
            push bx cx si
            mov cx,[cs:si+LensType.X]
            mov dx,[cs:si+LensType.Y]
            mov ax,cx                       ;\
            shl ax,1                        ; \
            add bx,ax                       ;  > add an offset to the row
            and bx,SineWaveLength -1        ; /
            add dx,[cs:SineCurve+bx]        ;/
            call MorphBuffer
            pop si cx bx
@@NextLens: add si,size LensType            ;point to the next lens
            dec cx                          ;\ loop until we're done
            jnz @@DoLenses                  ;/

            ;**** display the new buffer ****
            mov ax,WorkSegment
            mov ds,ax
            mov si,offset WorkBuffer
            mov ax,0A000h
            mov es,ax
            mov di,0
            mov cx,(320*200)/4
            cld
            rep movsd

            ;**** update the positions of the lenses ****
            call MoveLenses

            ;**** display the next column of text, if necessary ****
            call DoText
            jc @@Quit

            ;**** check stdio.  If something's been pressed, quit ****
            mov ah,6
            mov dl,0FFh
            int 21h
            jz @@MainLoop
            ;-----------------------------------------------------------------
@@Quit:     ;**** fade the screen to black ****
            call fade_out

            ;**** change back to text mode ****
            ;mov ax,0003h
            ;int 10h

            ;**** terminate program ****
            mov ax,4C00h
            int 21h
endp        Start
;
;put the portion of the screen that we've captured under the lens
;
;           CX = column of lens
;           DX = row of lens
proc        MorphBuffer
            mov si,cs
            mov ds,si
            mov si,offset Lens          ;DS:SI ==> lens transformation table

            ;sub cx,(LensDiameter/2)    ;\ use these if (col,row) is measured
            ;sub dx,(LensDiameter/2)    ;/ from the *center* of the lens
            mov ax,320
            mul dx
            add ax,cx

            mov di,WorkSegment
            mov es,di
            mov di,offset WorkBuffer
            add di,ax                   ;ES:DI ==> current position

            mov dx,LensDiameter
@@NextRow:      mov cx,LensDiameter
@@DoPoint:          mov bx,[word ds:si]
                    cmp bx,-1
                    jz @@NextPoint
                    
                    add bx,ax
                    mov bl,[byte es:WorkBuffer+bx]
                    or bl,128
                    mov [byte es:di],bl
@@NextPoint:        inc di
                    add si,2
                dec cx
                jnz @@DoPoint
            add di,320-LensDiameter
            dec dx
            jnz @@NextRow

            ret
endp        MorphBuffer
;
proc        DoText
            dec [cs:ScrollDelay]
            jnz @@NoText
            mov [cs:ScrollDelay],ScrollDelayInit

            mov si,[cs:ScrollPos]
            mov bl,[cs:ScrollText+si]       ;BL = current character
            xor bh,bh
            shl bx,4
            add bx,offset FontData
            mov ax,cs
            mov ds,ax
            mov si,bx                       ;DS:SI ==> this chararacter's data
            mov bx,16                       ;BX = number of rows to do
            mov cl,[cs:ScrollCol]           ;CL = number of places to shift
            mov ax,cs
            mov es,ax
            mov di,offset LensTable         ;ES:DI ==> lens structures
            mov dx,NumLenses                ;DX = number of lenses left
            cld
@@DoFont:   lodsb
            shr al,cl
            and al,1
            jz @@NoPoint
@@FindEmpty:cmp [es:di+LensType.Active],0
            jnz @@NotEmpty
            mov [es:di+LensType.X],319-LensDiameter
            push bx dx
            neg bx
            add bx,16
            mov ax,VerticalSpacing
            mul bx
            sub ax,(16/2)*VerticalSpacing
            pop dx bx
            mov [es:di+LensType.Y],ax
            mov [es:di+LensType.Active],1
            jmp @@NoPoint
@@NotEmpty: add di,size LensType
            dec dx
            jnz @@FindEmpty
            jmp @@TextDone
@@NoPoint:  dec bx
            jnz @@DoFont
@@TextDone: dec [cs:ScrollCol]
            jns @@NoText
            mov [cs:ScrollCol],7
            inc [cs:ScrollPos]
            mov bx,[cs:ScrollPos]
            cmp [byte cs:ScrollText+bx],0
            jnz @@NoText
            if LoopDemo eq 0
                stc
                ret
            else 
                mov [cs:ScrollPos],0
            endif

@@NoText:   clc
            ret
endp        DoText
;
proc        MoveLenses
            mov cx,NumLenses
            mov ax,cs
            mov ds,ax
            mov si,offset LensTable

@@DoLenses: cmp [si+LensType.Active],0
            jz @@NextLens

            sub [si+LensType.X],3
            cmp [si+LensType.X],0
            jge @@NextLens
            mov [si+LensType.Active],0
@@NextLens: add si,size LensType
            dec cx
            jnz @@DoLenses

            ret
endp        MoveLenses
;
ends        Code

segment     ImageSegment
include     "snowman.dmp"
ends        ImageSegment

segment     WorkSegment
label       WorkBuffer byte
ends        WorkSegment

            end     Start
