;	credits
;
;	(C)94 xToto/Valhalla
;
;	first presented at the xmas-party in herning/denmark

	.model	small

	 stack	100h

ZEOT		= 1
ZHEIGHT		= 2
ZSKIP		= 3
ZSLEEP		= 4
ZSPEED		= 5
ZTOP		= 6
ZBOTTOM		= 7
ZBORDER		= 8
ZEOL		= 10
		.data

ZNICE		EQU	ZTOP,ZBLUE,1,ZBOTTOM,ZBROWN,1
ZDARK		EQU	ZTOP,ZGREY,1,ZBOTTOM,ZGREY+7,-1

Zstring = $
		db	ZEOL
		db	ZBORDER,ZGREY
		db	ZNICE
		db	ZSPEED,7
		db	ZHEIGHT,16h
		db	'-V-A-L-H-A-L-L-A-',ZEOL
		db	ZSKIP,10h
		db	'PRESENTED',ZEOL
		db	ZSKIP,10h
		db	'PERIPHERAL VISION',ZEOL
		db	ZSKIP,30
		db	ZEOL
		db	ZSLEEP,210,ZEOL
		db	ZEOL
		db	'THE CREDITS',ZEOL
		db	'------------',ZEOL
		db	ZSKIP,30

		db	ZEOL
		db	'SANDMAN',ZEOL
		db	'-----------------',ZEOL
		db	'FRACTAL-MORPHER',ZEOL
		db	'CUBE',ZEOL
		db	'F15-FLIGHT',ZEOL
		db	'CANYON-FLIGHT',ZEOL
		db	'MISC.STUFF',ZEOL
		db	ZSKIP,1,ZEOL
		db	ZSLEEP,105,ZEOL
		db	ZEOL

		db	ZEOL
		db	'XTOTO',ZEOL
		db	'-----------------',ZEOL
		db	'CLOAKER',ZEOL
		db	'LANDSCAPE',ZEOL
		db	'CREDITS',ZEOL
		db	'MISC.STUFF',ZEOL
		db	ZSKIP,10,ZEOL
		db	ZSLEEP,105,ZEOL
		db	ZEOL

		db	ZEOL
		db	'OXIDE',ZEOL
		db	'-----------------',ZEOL
		db	'MUSIC',ZEOL
		db	ZSKIP,40,ZEOL
		db	ZSLEEP,105,ZEOL
		db	ZEOL

		db	ZEOL
		db	'HSI',ZEOL
		db	'-----------------',ZEOL
		db	'VALHALLA LOGO',ZEOL
		db	'CANYON GRAPHICS',ZEOL
		db	'THIS FONT',ZEOL
		db	ZSKIP,30,ZEOL
		db	ZSLEEP,105,ZEOL
		db	ZEOL

		db	ZEOL
		db	ZNICE
		db	'THE GREETINGS',ZEOL
		db	'--------------',ZEOL
		db	ZDARK
		db	ZEOL
		db	'B-WARE',ZEOL
		db	'BRITISH KNIGHTS',ZEOL
		db	'CAPACALA',ZEOL
		db	'COMPLEX',ZEOL
		db	'EMF',ZEOL
		db	'FUTURE CREW',ZEOL
		db	'GOLLUM',ZEOL
		db	'GRIF',ZEOL
		db	'HYSTERIA',ZEOL
		db	'IGUANA',ZEOL
		db	'IMPHOBIA-CASCADA',ZEOL
		db	'JAMM',ZEOL
		db	'KEFRENS',ZEOL
		db	'LEGEND DESIGN',ZEOL
		db	'LSD',ZEOL
		db	'PHANTOM DEZIGN',ZEOL
		db	'PRIME',ZEOL
		db	'SURPRISE PRODUCTIONS',ZEOL
		db	'SCOOPEX',ZEOL
		db	'SPACEBALLS',ZEOL
		db	'TET',ZEOL
		db	'THE COEXISTANCE',ZEOL
		db	'TRITON',ZEOL
		db	'VIRTUAL DREAMS',ZEOL
		db	'VLA',ZEOL
		db	'XOGRAPHY',ZEOL

		db	ZSKIP,80
		db	ZNICE
		db	'SANDMAN SENDS',ZEOL
		db	'SPECIAL GREETINGS TO',ZEOL
		db	ZDARK
		db	ZEOL
		db	'DARKSHADE',ZEOL
		db	'FEAR',ZEOL
		db	'JMAGIC',ZEOL
		db	'MARTIST',ZEOL
		db	'OC',ZEOL
		db	'OPTICS',ZEOL
		db	'PIT BULL',ZEOL
		db	'TRUG',ZEOL
		db	'YAKA',ZEOL
		db	'ZOOMBAPUP',ZEOL

		db	ZSKIP,50
		db	ZNICE
		db	'SANDMAN SENDS',ZEOL
		db	'NORMAL GREETINGS TO',ZEOL
		db	ZDARK
		db	ZEOL
		db	'ABYSS',ZEOL
		db	'AVATAR',ZEOL
		db	'BRAD CRAIG',ZEOL
		db	'BRI_ACID',ZEOL
		db	'BRIAN',ZEOL
		db	'DENTIST',ZEOL
		db	'DOOM',ZEOL
		db	'ERIK',ZEOL
		db	'FLAME',ZEOL
		db	'GTG',ZEOL
		db	'HENCHMAN',ZEOL
		db	'INTER',ZEOL
		db	'JARE',ZEOL
		db	'JAYKE',ZEOL
		db	'JCAB',ZEOL
		db	'LEV',ZEOL
		db	'LIKET',ZEOL
		db	'LITHIUM',ZEOL
		db	'LIZARDKING',ZEOL
		db	'MATRIX', ZEOL
		db	'MIKIE',ZEOL
		db	'PLASTIC SWIMMER',ZEOL
		db	'ROB BARTH',ZEOL
		db	'ROYAL SAM',ZEOL
		db	'SARACEN',ZEOL
		db	'STELIOS',ZEOL
		db	'THE FAKER',ZEOL
		db	'THE WIZARD',ZEOL
		db	'THUMPER',ZEOL
		db	'WELTI',ZEOL
		db	'WILDFIRE',ZEOL
		db	'WIZARD',ZEOL

		db	ZSKIP,80
		db	ZNICE
		db	'XTOTO GREETS',ZEOL
		db	ZDARK
		db	ZEOL
		db	'3R',ZEOL
		db	'ANTIBYTE',ZEOL
		db	'CASSIOPEIA',ZEOL
		db	'CHICKEN',ZEOL
		db	'CHRISTOPH',ZEOL
		db	'CHRISTIAN H',ZEOL
		db	'CHRISTIAN T',ZEOL
		db	'CORWIN',ZEOL
		db	'DAD',ZEOL
		db	'EDDIE',ZEOL
		db	'EINIE',ZEOL
		db	'GABI',ZEOL
		db	'GIDEON',ZEOL
		db	'HOLLE',ZEOL
		db	'JOHANNES',ZEOL
		db	'KARIN',ZEOL
		db	'MADMAX',ZEOL
		db	'MARC',ZEOL
		db	'MARTIST',ZEOL
		db	'MIKA',ZEOL
		db	'MOM',ZEOL
		db	'M_REX',ZEOL
		db	'MUSASHI',ZEOL
		db	'NEUROTICA',ZEOL
		db	'NOCTURNUS',ZEOL
		db	'OC',ZEOL
		db	'PIT BULL',ZEOL
		db	'PRE',ZEOL
		db	'PREMIERE',ZEOL
		db	'PSYCHED',ZEOL
		db	'RALF',ZEOL
		db	'SARACEN',ZEOL
		db	'SASCHA',ZEOL
		db	'SIMM',ZEOL
		db	'STEFAN E',ZEOL
		db	'STEFAN H',ZEOL
		db	'STRFX',ZEOL
		db	'TCMAN',ZEOL
		db	'THOMAS',ZEOL
		db	'WELTI',ZEOL
		db	'WERNER',ZEOL
		db	'WHITE WIZARD',ZEOL
		db	'WOLFGANG M',ZEOL
		db	'WOLFGANG S',ZEOL
		db	'YAKA',ZEOL
		db	'ZDEN',ZEOL

		db	ZSKIP,80
		db	ZNICE
		db	'OXIDE GREETS',ZEOL
		db	ZDARK
		db	ZEOL
		db	'XPEKTRUM SYSTEMS',ZEOL
		db	'ICH INC.',ZEOL
		db	'ASTRA/ADRAR DESIGN',ZEOL
		db	'M3/ISPANIA',ZEOL
		db	'AUDIN',ZEOL
		db	'SNOWMAN',ZEOL
		db	ZSKIP,10
		db	'ALL PPL I MEET IN',ZEOL
		db	'FIDONET AND INTERNET',ZEOL
        
		db	ZSKIP,80
		db	ZNICE
		db	'HSI GREETS',ZEOL
		db	ZDARK
		db	ZEOL
		db	'EVERYONE AT',ZEOL
		db	'WOLVERHAMPTON UNI',ZEOL
		db	ZSKIP,10
		db	'EVERYONE AT',ZEOL
		db	'DUDLEY COLLEGE',ZEOL
		db	ZSKIP,10
		db	'JIMBO',ZEOL

		db	ZSKIP,120
		db	ZNICE
		db	'THE END',ZEOL
		db	ZDARK
		db	ZSKIP,60,ZEOL
		db	ZSLEEP,140
		db	ZSKIP,200
		db	ZEOT

Zpstring	dw	offset Zstring
Zpstart		dw	0
Zostart		dw	0
Zcharln		dw	0
Zcharhgt	dw	14h
Zdelta		dw	100h
Zy		dw	0
Zy2		dw	0
ZSLEEPer	db	0
ZSKIPper	db	0

Zshadow		db	2,1,3,2
		db	1,1,3,1
		db	3,1,3,3
		db	2,1,3,2
		db	0

Zpattern	db	0

Zfade		=	$
Zfade_top	db	5,6,7,8,9,10,11,12
Zfade_bottom	db	13,14,15,16,17,18,19,20

Zleft		db	1
Zright		db	3

Zcolormap	db	000h, 000h, 000h ; ##
ZSTAR = 1
		db	017h, 017h, 017h
ZGREEN = 2
;		db	000h, 000h, 000h ; green
;		db	007h, 00fh, 007h
;		db	00dh, 01bh, 00dh
;		db	013h, 027h, 013h
;		db	019h, 033h, 019h
;		db	01fh, 03fh, 01fh
;		db	02ah, 03fh, 02ah
;		db	035h, 03fh, 035h
ZRED = 10
;		db	000h, 000h, 000h ; red
;		db	00fh, 007h, 007h
;		db	01bh, 00dh, 00dh
;		db	027h, 013h, 013h
;		db	033h, 019h, 019h
;		db	03fh, 01fh, 01fh
;		db	03fh, 02ah, 02ah
;		db	03fh, 035h, 035h
ZGREY = (offset $ - offset Zcolormap) / 3
		db	000h, 000h, 000h ; grey
		db	007h, 007h, 007h
		db	00fh, 00fh, 00fh
		db	017h, 017h, 017h
		db	01fh, 01fh, 01fh
		db	027h, 027h, 027h
		db	02fh, 02fh, 02fh
		db	037h, 037h, 037h
ZBLUE = (offset $ - offset Zcolormap) / 3
		db	000h, 000h, 000h ; blue
		db	006h, 008h, 00fh
		db	00ch, 00eh, 01bh
		db	012h, 014h, 027h
		db	018h, 01ah, 033h
		db	01eh, 020h, 03fh
		db	027h, 029h, 03fh
		db	02fh, 031h, 03fh
ZBROWN = (offset $ - offset Zcolormap) / 3
		db	000h, 000h, 000h ; brown
		db	00ch, 00ah, 007h
		db	016h, 012h, 00dh
		db	020h, 01ah, 013h
		db	02ah, 022h, 019h
		db	032h, 02ch, 01fh
		db	037h, 033h, 02ah
		db	03bh, 039h, 035h
Zcolors		= offset $ - offset Zcolormap

Zbuffer		db	12h*12h dup (0)

include	font.inc

Zfont	db	chars*16*16 dup (?)

Zstarsx	dw	2*200 dup (?)

	.code
	.286
Zclean_up:
	mov	ax, 03h
	int	10h
	mov	ax, 4c00h
	int	21h

Zclear_line:
	mov	di, Zpstart
	xor	ax, ax
	mov	cx, 320/2
Zclear_line1:
	mov	es:[di], ax
	add	di, 2
	dec	cx
	jnz	Zclear_line1
	ret

Zdraw_line:
	mov	si, Zpstring
	xor	bx, bx
Zdraw_line1:
	mov	al, ds:[si+bx]
	inc	bx
	cmp	al, ZEOL
	jne	Zdraw_line1
	dec	bx
	jz	Zdraw_line7
	mov	cx, bx
	mov	di, cx
	shl	di, 3
	sub	di, 160
	neg	di
	add	di, Zpstart
Zdraw_line2:
	push	cx
	xor	bh, bh
	mov	bl, [si]
	sub	bx, 020h
	add	bx, bx
	mov	bx, ds:chardata[bx]
	mov	dx, Zcharln
	shl	dx, 4
	add	bx, dx
	mov	cx, 16
Zdraw_line3:
	mov	al, ds:[bx]
	cmp	al, 2
	jnz	Zdraw_line4
	mov	al, Zpattern
Zdraw_line4:
	cmp	al, 1
	jnz	Zdraw_line5
	mov	al, Zleft
Zdraw_line5:
	cmp	al, 3
	jnz	Zdraw_line6
	mov	al, Zright
Zdraw_line6:
	mov	byte ptr es:[di], al
	inc	di
	inc	bx
	add	dx, dx
	dec	cx
	jnz	Zdraw_line3
	inc	si
	pop	cx
	dec	cx
	jnz	Zdraw_line2
Zdraw_line7:
	ret

Zinit:
	mov	ax, seg _DATA
	mov	ds, ax
	mov	ax, 0a000h
	mov	es, ax
	call	Zinit_font
	call	Zinit_gfx
	call	Zinit_stars
	ret

Zinit_gfx:
	mov	ax, 013h
	int	10h
	mov	dx, 03c8h
	xor	al, al
	out	dx, al
	inc	dx
	mov	si, offset Zcolormap
	mov	cx, Zcolors
	rep	outsb
	ret

Zinit_stars:
	mov	bp, 7111h
	mov	cx, 200
	mov	di, offset Zstarsx
Zinit_stars1:
	mul	bp
	xor	ax, 5908h
	mov	ds:[di], ax
	rol	ax, 7
	mul	bp
	xor	ax, 0588h
	mov	ds:[di+2], ax
	and	word ptr ds:[di+2], 00f8h
	add	word ptr ds:[di+2], 20h
	rol	ax, 5
	add	di, 4
	dec	cx
	jnz	Zinit_stars1
	ret

Zkey_pressed:
	mov	ah, 01h
	int	16h
	ret

Zmain:
	call	Zinit
Zmain1:
	call	Zrun
	call	Zkey_pressed
	jz	Zmain1
	call	Zclean_up

Zmove_stars:
	mov	cx, 200
	mov	bp, offset Zstarsx
	mov	di, Zpstart
	add	di, 576
	mov	si, Zostart
	add	si, 576
Zmove_stars1:
	mov	bx, ds:[bp]
	mov	ax, bx
	shr	bx, 7
	cmp	bx, 319
	ja	Zmove_stars2
	cmp	byte ptr es:[si+bx], ZSTAR ; ##
	jne	Zmove_stars2
	mov	byte ptr es:[si+bx], 0
Zmove_stars2:
	add	ax, ds:[bp+2]
	mov	ds:[bp], ax
	shr	ax, 7
	cmp	ax, 319
	ja	Zmove_stars3
	mov	bx, ax
	cmp	byte ptr es:[di+bx], 0
	jne	Zmove_stars3
	mov	byte ptr es:[di+bx], ZSTAR
Zmove_stars3:
	add	bp, 4
	add	di, 320
	add	si, 320
	dec	cx
	jnz	Zmove_stars1
	ret

Znext_line:
	mov	si, Zpstring
Znext_line1:
	lodsb
	cmp	al, ZEOL
	jne	Znext_line1
Znext_line2:
	lodsb
	cmp	al, ' '
	jae	Znext_line_end

	cmp	al, ZSLEEP
	jne	Znext_line_nosleep
	lodsb
	mov	Zsleeper, al
	jmp	Znext_line2
Znext_line_nosleep:

	cmp	al, ZSPEED
	jne	Znext_line_nospeed
	lodsb
	mov	cl, al
	mov	ax, 0001h
	shl	ax, cl
	mov	Zdelta, ax
	jmp	Znext_line2
Znext_line_nospeed:

	cmp	al, ZTOP
	jne	Znext_line_notop
	lodsw
	mov	cx, 8
	mov	bx, offset Zfade_top
Znext_line_top:
	mov	ds:[bx], al
	inc	bx
	add	al, ah
	dec	cx
	jnz	Znext_line_top
	jmp	Znext_line2
Znext_line_notop:

	cmp	al, ZBOTTOM
	jne	Znext_line_nobottom
	lodsw
	mov	cx, 8
	mov	bx, offset Zfade_bottom
Znext_line_bottom:
	mov	ds:[bx], al
	inc	bx
	add	al, ah
	dec	cx
	jnz	Znext_line_bottom
	jmp	Znext_line2
Znext_line_nobottom:

	cmp	al, ZBORDER
	jne	Znext_line_noborder
	lodsb
	add	al, 2
	mov	Zright, al
	add	al, 3
	mov	Zleft, al
	jmp	Znext_line2
Znext_line_noborder:
	cmp	al, ZHEIGHT
	jne	Znext_line_noheight
	lodsb
	xor	ah, ah
	mov	Zcharhgt, ax
	jmp	Znext_line2

Znext_line_noheight:
	cmp	al, ZSKIP
	jne	Znext_line_noskip
	lodsb
	mov	Zskipper, al
	jmp	Znext_line2

Znext_line_noskip:
	cmp	al, ZEOT
	jne	Znext_line_noeot
	mov	si, offset Zstring+1

Znext_line_noeot:
Znext_line_end:
	dec	si
	mov	Zpstring, si
	ret

Zinit_font:
	mov	di, offset Zfont
	mov	si, offset char00
	mov	cx, chars
Zinit_font1:
	push	cx
	mov	bp, offset Zbuffer + 11h
	mov	cx, 10h
Zinit_font2:
	push	cx
	mov	dx, [si]
;	add	dl, dl
	inc	si
	inc	si
	mov	cx, 10h
Zinit_font3:
	xor	al, al
	add	dx, dx
	adc	al, 0
	mov	ds:[bp], al
	inc	bp
	dec	cx
	jnz	Zinit_font3
	inc	bp
	inc	bp
	pop	cx
	dec	cx
	jnz	Zinit_font2

	mov	cx, 10h
	mov	bp, offset Zbuffer + 11h
Zinit_font4:
	push	cx
	mov	cx, 10h
Zinit_font5:
	xor	bx, bx
	cmp	byte ptr ds:[bp], 0
	jne	Zinit_font_do
	mov	bl, 10h
	jmp	Zinit_font_s4
Zinit_font_do:
	cmp	byte ptr ds:[bp-1], 0
	jz	Zinit_font_s1
	or	bl, 1
Zinit_font_s1:
	cmp	byte ptr ds:[bp+1], 0
	jz	Zinit_font_s2
	or	bl, 2
Zinit_font_s2:
	cmp	byte ptr ds:[bp-12h], 0
	jz	Zinit_font_s3
	or	bl, 4
Zinit_font_s3:
	cmp	byte ptr ds:[bp+12h], 0
	jz	Zinit_font_s4
	or	bl, 8
Zinit_font_s4:
	mov	al, Zshadow[bx]
	mov	ds:[di], al
	inc	di
	inc	bp
	dec	cx
	jnz	Zinit_font5
	inc	bp
	inc	bp
	pop	cx
	dec	cx
	jnz	Zinit_font4

	pop	cx
	dec	cx
	jnz	Zinit_font1

	mov	si, offset chardata
	mov	cx, 64
Zinit_font6:
	mov	bx, [si]
	sub	bx, offset char00
	shl	bx, 3
	add	bx, offset Zfont
	mov	[si], bx
	inc	si
	inc	si
	dec	cx
	jnz	Zinit_font6
	ret

Zproceed:
	add	Zpstart, 320
	mov	cx, Zpstart
	add	cx, 576
	shr	cx, 2
	mov	dx, 03d4h
	mov	ah, ch
	mov	al, 00ch
	out	dx, ax
	mov	ah, cl
	mov	al, 00dh
	out	dx, ax
	mov	ax, Zcharln
	cmp	Zcharhgt, ax		; check for new line
	jne	Zproceed1
	mov	Zcharln, 0
	call	Znext_line
Zproceed1:
	mov	bx, Zcharln
	add	bx, offset Zfade
	mov	al, ds:[bx]
	mov	Zpattern, al
	ret

Zrun:
	cmp	Zsleeper, 0		; sleep on demand
	je	Zrun1
	dec	Zsleeper
	jmp	Zrun_end
Zrun1:
	mov	ax, Zy
	mov	Zy2, ax
	mov	cx, ax
	add	cx, Zdelta
	mov	Zy, cx
	shr	ax, 8
	shr	cx, 8
	sub	cx, ax
	and	cx, 00ffh
	jz	Zrun_end
Zrun_loop:
	push	cx
	call	Zclear_line
	cmp	Zskipper, 0
	je	Zrun_no_skip
	dec	ZSkipper
	jmp	Zrun_was_skip
Zrun_no_skip:
	cmp	Zcharln, 10h
	jae	Zrun_no_char
	call	Zdraw_line
Zrun_no_char:
	inc	Zcharln
Zrun_was_skip:
	call	Zproceed
	pop	cx
	dec	cx
	jnz	Zrun_loop
Zrun_end:
	call	Zsync
	call	Zmove_stars
	mov	ax, Zpstart
	mov	Zostart, ax
	ret

Zsync:
	mov	dx, 03dah
Zsync1:
	in	al, dx
	test	al, 8
	jz	Zsync1
Zsync2:
	in	al, dx
	test	al, 8
;	jnz	Zsync2
	ret

	end Zmain
