
PSPseg  dw  ?
DTAseg  dw  ?
ENVseg  dw  ?

FileSpec    db  "*.*",0
CurDir      db  "?:\"
 DirBuff    db  64 dup (0)

Msg_DirOf   db  "  Directory of ",0
Msg_Spaces  db  "  ",0
Msg_Bytes   db  " total bytes",13,10,0
Msg_Files   db  " files",0
Msg_File    db  " file ",0
Msg_indent  db  "                ",0
Msg_Free    db  " bytes free ",0
Msg_Percent db  "%)"    ;,13,10,0
Msg_CrLf    db  13,10,0

STRUC DTA
    stuff   db  21 dup (?)
    Attr    db  ?
    Time    dw  ?
    Date    dw  ?
    Size    dd  ?
    Fname   db  13 dup (0)
ENDS

SizeSum     dd  0
NumFiles    dd  0

Msg_Entry   db  "FileName Ext "
 E_size     db  "9999999999  ",0

    
    ; Finds either the first or next entry. Updates the DTA
    ;
    ; IN: DS:DX points to ASCIIZ filename match
    ;      AL = 4eh for Find First, 4fh for find next
    ;      CX = attributes to search for
    ;
    ;OUT: CF = 0, Buffer is filled
    ;     CF = 1, no more files, buffer unchanged
    
PROC FindFile NEAR
    pusha

    int     21h
    cmp     al,18
    je   short @@NoMore
    cmp     al,2
    je   short @@NoMore
    
    clc
    popa
    ret

@@NoMore:
    stc
    popa
    ret
ENDP
    
    ; Finds either the first or next entry and puts it in a buffer
    ;
    ; IN:   FS = Ptr to the DTA segment
    
PROC PrintEntry NEAR
    pusha
    push    ds es
    mov     ax,cs
    mov     ds,ax
    mov     es,ax

    mov     di,offset Msg_Entry
    
    push    di
    mov     cx,23       ;clear out entry
    mov     al," "
    rep stosb
    pop     di

    inc     [NumFiles]
    mov     ah,2
    xor     bx,bx
    mov     cx,13
    test    [fs:(DTA).Attr],00010000b
    jz  short @@Ploop

 ;do a directory..

    dec     [NumFiles]
    dec     cl
    mov     al,"["
    stosb
@@DLoop:
    mov     al,[fs:bx + (DTA).FName]
    or      al,al
    je short @@DDone
    stosb
    inc     bx
    loop    @@Dloop

@@DDone:
    mov     al,"]"
    stosb
    add     cx,10
    mov     al," "
    rep     stosb
    jmp short @@END

@@PLoop:
    mov     al,[fs:bx + (DTA).FName]
    or      al,al
    je  short @@Done
    cmp     al,"."
    je  short @@HitDot
    stosb
    inc     bx
    loop    @@Ploop
    jmp short @@Done

@@HitDot:
    sub     cx,4
    jle short @@Done
    mov     al," "
    rep stosb
    mov     cx,4
    inc     bx
    jmp short @@PLoop

@@Done:
    add     cx,2
    mov     al," "
    rep stosb
    
@@COnt:
    mov     eax,[fs:(DTA).Size]
    mov     cx,8
    add     [SizeSum],eax
    call    DEC_Print2Mem

@@End:
    mov     si,offset Msg_Entry
    call    PrintZ

    pop     es ds
    popa
    ret
ENDP
    
    ; Prints out the message ' Directory of c:\directory\name '
    ;
    ; IN: DS = segment that all the data is in
    
PROC DisplayDirectory NEAR
    pusha
    mov     si,offset Msg_DirOf
    call    PrintZ

    mov     ah,19h
    int     21h
    add     al,"A"
    mov     [CurDir],al

    mov     ah,47h
    xor     dl,dl
    mov     si,offset DirBuff
    int     21h
    mov     si,offset CurDir
    call    PrintZ
    mov     si,offset Msg_CRLF
    call    PrintZ

    popa
    ret
ENDP
    
    ; Displays the number of files, # of bytes used, bytes free, 
    ; and % free on the disk
    
PROC PrintStats NEAR
    pusha
    mov     cx,10
    mov     eax,[NumFiles]
    call    Dec_Print
    
    mov     si,offset Msg_Files
    cmp     [NumFiles],1
    jne short @@OK
    mov     si,offset Msg_File
@@OK:
    call    PrintZ

    mov     cx,10
    mov     eax,[SizeSum]
    call    Dec_Print

    mov     si,offset Msg_Bytes
    call    PrintZ

    mov     si,offset Msg_Indent
    call    PrintZ

    mov     ah,36h
    xor     dl,dl
    int     21h

    mul     bx
    shl     edx,16
    mov     dx,ax
    movzx   eax,cx
    mul     edx
    mov     cx,10
    call    DEC_Print

    mov     si,offset Msg_free
    call    PrintZ

    mov     ah,2
    mov     dl,"("
    int     21h

    mov     ah,36h
    xor     dl,dl
    int     21h
    movzx   eax,bx
    imul    eax,100
    movzx   ecx,dx

    push    eax ecx

    xor     edx,edx
    div     ecx
    push    eax
    mov     cx,2
    call    Dec_Print

    mov     ah,2
    mov     dl,"."
    int     21h

    pop     ebx ecx eax
    imul    eax,1000
    xor     edx,edx
    div     ecx
    imul    ebx,1000
    sub     eax,ebx
    mov     cx,3
    call    Dec_Print

    mov     si,offset Msg_Percent
    call    PrintZ
    popa
    ret
ENDP
    
    ; Finds and displays all matching files.
    
PROC PrintEntries NEAR
    pusha
    push    fs
    mov     fs,[cs:DTAseg]

    mov     dx,offset FileSpec
    mov     cx,0110111b        ;search for all files
    mov     ah,4eh              ;find first
    call    FindFile
    jc  short @@END

    call    PrintEntry

    mov     bp,2
@@listLoop:
    mov     dx,offset FileSpec
    mov     cx,0110111b        ;search for all files
    mov     ah,4fh              ;find next
    call    FindFile
    jc  short @@END

    call    PrintEntry
    
    dec     bp
    jne short @@ListLoop

    mov     bp,3

    mov     si,offset Msg_Spaces
    call    PrintZ
    jmp short @@ListLoop

@@END:
    mov     si,offset Msg_CRLF
    call    PrintZ
    pop     fs
    popa
    ret
ENDP

    
    ;   Prints azero terminating string
    ;
    ; IN: ds:si = source
    ;OUT:    cx = # of char written
    
PROC PrintZ
    push    si dx ax
    cld
    xor     cx,cx
@@TheLoop:
    mov     dl,[si]
    or      dl,dl
    je  short @@Done
    mov     ah,2
    int     21h

    inc     cx
    inc     si
    jmp short @@TheLoop

@@Done:
    pop     ax dx si
    ret
ENDP
    
    ; Print a number to memory
    ; does not print leading zeros... prints spaces instead  
    ;
    ;IN: eax = number to print
    ;     cx = number of digits to print (max 11)
    ;  es:di = where to put the output
    
PROC DEC_Print2Mem NEAR
    push    bp cx eax edx ebx si
    cld
    mov     bp,cx
    
    cld
    xor     si,si
    or      eax,eax
    jns short @@NoPrintSign
    inc     si              ;si not zero means we print a sign
    dec     bp              ;count the sign
    neg     eax
@@NoPrintSign:

    mov     cx,11
    mov     ebx,10
@@DLNum:
    xor     edx,edx
    div     ebx
    add     dl,'0'
    push    dx      ;push the result
    loop    @@DLNum

    mov     cx,11
    mov     dh,0    ;flag if we hit non-zero yet
@@DLNum2:
    pop     ax
    cmp     cx,bp
    ja  short @@DontPrintThisYet
    cmp     al,"0"
    jne short @@NotZero
    or      dh,dh
    jne short    @@NotZero
    cmp     cx,1
    je  short    @@NotZero   ;print last zero if its leading
    mov     al,' '
    jmp short    @@PrintIt
@@NotZero:
    inc     dh
    dec     si
    js  short    @@PrintIt
    mov     [BYTE es:di],"-"
    inc     di
@@Printit:
    stosb
@@DontPrintThisYet:
    loop    @@DLNum2
    
    pop     si ebx edx eax cx bp
    ret
ENDP
    
    ; Print a number to the screen
    ; does not print leading zeros... prints spaces instead
    ;
    ;IN: eax = number to print
    ;     cx = number of digits to print (max 11)
    
PROC DEC_Print NEAR
    push    bp cx eax edx ebx si
    cld
    mov     bp,cx
    
    xor     si,si
    or      eax,eax
    jns  short   @@PrintSign
    inc     si              ;si not zero means we print a sign
    dec     bp              ;count the sign
    neg     eax
@@PrintSign:

    mov     cx,11
    mov     ebx,10
@@DLNum:
    xor     edx,edx
    div     ebx
    add     dl,'0'
    push    dx      ;push the result
    loop    @@DLNum

    mov     cx,11
    mov     dh,0    ;flag if we hit non-zero yet
@@DLNum2:
    pop     ax
    cmp     cx,bp
    ja   short   @@DontPrintThisYet
    cmp     al,"0"
    jne  short   @@NotZero
    or      dh,dh
    jne  short   @@NotZero
    cmp     cx,1
    je   short   @@NotZero   ;print last zero if its leading
    mov     al,' '
    jmp  short   @@PrintIt
@@NotZero:
    inc     dh
    dec     si
    js   short   @@PrintIt
    push    ax
    mov     ah,2
    mov     dl,"-"
    int     21h
    pop     ax
@@Printit:
    mov     ah,2
    mov     dl,al
    int     21h
@@DontPrintThisYet:
    loop    @@DLNum2

    pop     si ebx edx eax cx bp
    ret
ENDP
