		TITLE	'Connect'

		PAGE	66, 132

		P286
		MODEL	COMPACT

INCLUDE		INCLUDE\DOS.INC
INCLUDE		INCLUDE\KEYCODES.INC

STRWARN		EQU	KBLF, KBCR, '$'
CBBUFFER	EQU	01000H

Data		SEGMENT	PUBLIC
		ASSUME	cs:Code, ds: Data

STREXTWRT	DB	'.WRT', 0
STREXTEXE	DB	'.EXE', 0
STRCOPYERROR	DB	'Can''t create EXE-File entirely.', STRWARN
STRCREATEERROR	DB	'Can''t create EXE-File.', STRWARN
STRFINDERROR	DB	'Can''t find WRT-File.', STRWARN
STROPENERROR	DB	'Can''t open WRT-File.', STRWARN
STRREADERROR	DB	'Can''t read from WRT-File.', STRWARN
STRWRITEERROR	DB	'Can''t write to EXE-File.', STRWARN
STRUSAGE	DB	'Usage: CONNECT <FileName>', STRWARN

cbLoEXE		=	$ + 2
cbHiEXE		=	$ + 4

ABFILE		LABEL
INCLUDE		PLAY.INC

CBFILE		=	OFFSET $ - OFFSET ABFILE

cbLoWrite	DW	?
cbHiWrite	DW	?
hWrite		DW	?
hEXE		DW	?
segFileName	DW	?
offsFileName	DW	?
offsExt		DW	?

abBuffer	DB	CBBUFFER DUP (?)
Data		ENDS

Stack		0100H

Code		SEGMENT	PUBLIC
		ASSUME	cs:Code, ds: Data

CloseEXE	PROC
		pusha
		mov	ah, DOS_CLOSE_FILE
		mov	bx, hEXE
		int	DOS_FUNCTION
		popa
		ret
CloseEXE	ENDP

CloseWrite	PROC
		pusha
		mov	ah, DOS_CLOSE_FILE
		mov	bx, hWrite
		int	DOS_FUNCTION
		popa
		ret
CloseWrite	ENDP

; *****************************************************************************
; Erstellung der ausfhrbaren Datei
; *****************************************************************************
CreateEXE	PROC
		pusha

;		Endung des Dateinamens ndern
;
		mov	di, offsExt
		mov	si, OFFSET STREXTEXE
		mov	cx, 5
		rep	movsb

;		Datei zur Ausgabe ffnen
;
		mov	ah, DOS_CREATE_FILE
		xor	cx, cx
		mov	dx, offsFileName
		push	ds
		push	es
		pop	ds
		int	DOS_FUNCTION
		pop	ds
		jc      CreateEXE_Error
		mov	WORD PTR hEXE, ax

;		Lnge in EXE-Kopf ndern
;
		mov	ax, WORD PTR cbLoWrite
		mov	dx, ax
		and	ax, 001FFH
		shr	dx, 9
		add	dx, WORD PTR cbHiWrite
		add	WORD PTR cbLoEXE, ax
		cmp	WORD PTR cbLoEXE, 00200H
		jnae	CreateEXE_NoOv
		sub	WORD PTR cbLoEXE, 00200H
		inc	WORD PTR cbHiEXE

CreateEXE_NoOv:	add	WORD PTR cbHiEXE, dx
		clc
		jmp	CreateEXE_End

CreateEXE_Error:mov	dx, OFFSET STRCREATEERROR
		mov	ah, DOS_WRITE_STRING
		int	DOS_FUNCTION
		stc

CreateEXE_End:	popa
		ret
CreateEXE	ENDP

; *****************************************************************************
; Bestimmung des Dateinamens
; *****************************************************************************
GetWrite	PROC
		pusha

;		Kontrolle, ob Dateiname angegeben ist
;
		mov	WORD PTR segFileName, es
		mov	di, 080H
		mov	al, es:[di]
		or	al, al
		je	GetWrite_Help

;		Nullzeichen einfgen
;
		xor	ah, ah
		inc	di
		mov	si, di
		add	di, ax
		mov	es:[di], ah

;		Fhrende Leerzeichen berspringen
;
		mov	di, si
		mov	cx, ax
		mov	bx, ax
		mov	al, ' '
		repe	scasb
		or	cx, cx
		jne	GetWrite_Ok2
		mov	dx, WORD
		stc
		jmp	GetWrite_Error
GetWrite_Ok2:	dec	di
		mov	WORD PTR offsFileName, di

;		Endung suchen
;
		mov	di, si
		mov	cx, bx
		mov	al, '.'
		repne	scasb
		or	cx, cx
		jne	GetWrite_GetExt

;		Endung .WRT anfgen
;
		mov	WORD PTR offsExt, di
		mov	si, OFFSET STREXTWRT
		mov	cx, 5
		rep	movsb
		jmp	GetWrite_Ok

GetWrite_Error:	mov	dx, OFFSET STRFINDERROR
		mov	ah, DOS_WRITE_STRING
		int	DOS_FUNCTION
		stc
		jmp	GetWrite_End

GetWrite_GetExt:dec	di
		mov	WORD PTR offsExt, di

GetWrite_Help:	mov	dx, OFFSET STRUSAGE
		mov	ah, DOS_WRITE_STRING
		int	DOS_FUNCTION
		stc
		jmp	GetWrite_End

GetWrite_Ok:	clc

GetWrite_End:	popa
		ret
GetWrite	ENDP

; *****************************************************************************
; Initialisierung der Register
; *****************************************************************************
Init		PROC
		push	ax
		mov	ax, SEG Data
		mov	ds, ax
		pop	ax
		ret
Init		ENDP

; *****************************************************************************
; Hauptteil
; *****************************************************************************
Main		PROC
		call	Init
		call	GetWrite
		jc	Main_End
		call	OpenWrite
		jc	Main_End
		call	CreateEXE
		jc	Main_CloseWrite
		call	WriteEXE
		call	CloseEXE
Main_CloseWrite:call	CloseWrite
Main_End:	mov	al, 0
		adc	al, al
		mov	ah, DOS_TERMINATE_EXE
		int	DOS_FUNCTION
Main		ENDP

OpenWrite	PROC
		pusha
		mov	ah, DOS_OPEN_FILE
		xor	al, al
		mov	dx, WORD PTR offsFileName
		push	ds
		push	es
		pop	ds
		int	DOS_FUNCTION
		pop	ds
		jc	OpenWrite_Error
		mov	WORD PTR hWrite, ax

;		Dateilnge bestimmen
;
		mov	ah, DOS_MOVE_FILE_POINTER
		mov	al, 2
		mov	bx, WORD PTR hWrite
		xor	cx, cx
		xor	dx, dx
		int	DOS_FUNCTION
		jc	OpenWrite_Error
		mov	WORD PTR cbHiWrite, dx
		mov	WORD PTR cbLoWrite, ax

;		Dateizeiger an Anfang setzen
;
		mov	ah, DOS_MOVE_FILE_POINTER
		mov	al, 0
		xor	dx, dx
		int	DOS_FUNCTION
		clc
		jmp     OpenWrite_End

;		Fehlermeldung ausgeben
;
OpenWrite_Error:mov	dx, OFFSET STROPENERROR
		mov	ah, DOS_WRITE_STRING
		int	DOS_FUNCTION
		stc

OpenWrite_End:	popa
		ret
OpenWrite	ENDP

WriteEXE	PROC
		pusha

;		Abspieler in EXE-Datei schreiben
;
		mov	ah, DOS_WRITE_TO_HANDLE
		mov	bx, hEXE
		mov	cx, CBFILE
		mov	dx, OFFSET ABFILE
		int	DOS_FUNCTION
		jc	WriteEXE_WErr
		cmp	ax, cx
		jne	WriteEXE_WErr

;		Datenblock aus Write-Datei lesen
;
WriteEXE_RNext:	mov	ah, DOS_READ_FROM_HANDLE
		mov	bx, hWrite
		mov	cx, CBBUFFER
		mov	dx, OFFSET abBuffer
		int	DOS_FUNCTION
		jc	WriteEXE_RErr
		or	ax, ax
		je	WriteEXE_Done

;		Restlnge vermindern
;
		sub	WORD PTR cbLoWrite, ax
		jnc	WriteEXE_WNext
		dec	WORD PTR cbHiWrite

;		Datenblock in EXE-Datei schreiben
;
WriteEXE_WNext:	mov	bx, hEXE
		mov	cx, ax
		mov	ah, DOS_WRITE_TO_HANDLE
		mov	dx, OFFSET abBuffer
		int	DOS_FUNCTION
		jc	WriteEXE_WErr
		cmp	ax, cx
		jne	WriteEXE_WErr
		jmp	WriteEXE_RNext

;		Kontrolle, ob die ganze Datei kopiert wurde
;
WriteEXE_Done:	cmp	cbLoWrite, 0
		jne	WriteEXE_CErr
		cmp     cbHiWrite, 0
		jne	WriteEXE_Cerr
		jmp	WriteEXE_End

WriteEXE_CErr:	mov	ah, DOS_WRITE_STRING
		mov	dx, OFFSET STRCOPYERROR
		int	DOS_FUNCTION
		stc
		jmp	WriteEXE_End

WriteEXE_RErr:	mov	ah, DOS_WRITE_STRING
		mov	dx, OFFSET STRREADERROR
		int	DOS_FUNCTION
		stc
		jmp	WriteEXE_End

WriteEXE_WErr:	mov	ah, DOS_WRITE_STRING
		mov	dx, OFFSET STRWRITEERROR
		int	DOS_FUNCTION
		stc

WriteEXE_End:	popa
		ret
WriteEXE	ENDP

Code		ENDS

		END	Main
