COMMENT $    


This program shows the speed of your VGA card in three different modes-

 1: Dumping a constant value to the VGA card (via REP STOSD)

 2: Copying a page from memory to the VGA card (via REP MOVSD) - 
    this is used with virtual screens..

 3: Copying Video memory to video memory - SLOW!!


Times I got for my 386-40 w/ Tseng4000 Hi-Color VGA card:

    1:  125 fps
    2:  105 fps
    3:   43 fps

Times I got for the same system, but I commented out the line that puts
 the card back in Linear mode: (ie. Times in planar or modex)
 To try this mode yourself, comment out the line "call ResetLinear"
 
    1:  113 fps
    2:   97 fps
    3:   36 fps

Draeden /VLA

$
    
    Ideal
    Model Small
    Stack 200h
    CodeSeg
    Assume CS:@Code, DS:@Code
    p386


INCLUDE "Modex2.Inc"
INCLUDE "TimerSub.Inc"

Counter dd  0

Time1   dd  0
Time2   dd  0
Time3   dd  0

MSG_Title   db  13,10," Frames per second for various VGA operations."
            db  13,10,"$"

MSG_2VGA    db  13,10,"Writing to the screen     (2VGA): $"
MSG_MEM2VGA db  13,10,"Copy Memory to the VGA (Mem2VGA): $"
MSG_VGA2VGA db  13,10,"Copy VGA to VGA        (VGA2VGA): $"

PROC FillVGA NEAR
    mov     es,[VGAseg]
    xor     di,di
    mov     eax,[Counter]
    xor     eax,55555555h
    cld
    mov     cx,256*240/4
    rep     stosd

    ret
ENDP

PROC CMem2VGA NEAR
    mov     es,[VGAseg]
    xor     di,di
    xor     si,si
    cld
    mov     cx,256*240/4
    rep     movsd

    ret
ENDP

PROC CVGA2VGA NEAR
    push    ds
    mov     es,[VGAseg]
    mov     ds,[VGAseg]
    xor     di,di
    mov     si,4
    cld
    mov     cx,256*240/4
    rep     movsd
    pop     ds
    ret
ENDP

START:
    mov     ax,cs
    mov     ds,ax

    @SetModeX x256, y480, 2, 256
    call    ResetLinear

    mov     [Counter],256
    call    StartTimer
MainLoop1:
    call    FillVGA

    dec     [Counter]
    jnz     MainLoop1
    
    call    StopTimer
    
    mov     eax,[TimerE]
    sub     eax,[TimerS]
    imul    eax,10
    mov     [Time1],eax
    
    mov     [Counter],256
    call    StartTimer
MainLoop2:
    call    Cmem2VGA

    dec     [Counter]
    jnz     MainLoop2
    
    call    StopTimer
    
    mov     eax,[TimerE]
    sub     eax,[TimerS]
    imul    eax,10
    mov     [Time2],eax


    mov     [Counter],256
    call    StartTimer
MainLoop3:
    call    CVGA2VGA

    dec     [Counter]
    jnz     MainLoop3
    
    call    StopTimer
    
    mov     eax,[TimerE]
    sub     eax,[TimerS]
    imul    eax,10
    mov     [Time3],eax

    mov     ax,3
    int     10h

    mov     dx,offset Msg_Title
    mov     ah,9
    int     21h

    mov     dx,offset Msg_2VGA
    mov     ah,9
    int     21h

    mov     eax,256*182
    xor     edx,edx
    mov     ecx,[Time1]
    div     ecx
    call    PrintDouble

    mov     dx,offset Msg_MEM2VGA
    mov     ah,9
    int     21h

    mov     eax,256*182
    xor     edx,edx
    mov     ecx,[Time2]
    div     ecx
    call    PrintDouble

    mov     dx,offset Msg_VGA2VGA
    mov     ah,9
    int     21h

    mov     eax,256*182
    xor     edx,edx
    mov     ecx,[Time3]
    div     ecx
    call    PrintDouble

    mov     ax,4c00h
    int     21h
END START
