        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include argc.inc
include vrt.inc
include v.inc

public  _vidptr, _pagehibyte

public  _gnbg_setup, _gnbg_draw, _gnbg_flip

;
; DATA
;
align 4
gnbgtbl         label   word
include gnbgtbl.m

gnbgtbltbl      label   dword
temp=offset gnbgtbl
rept 320
        dd      temp
temp=temp+2*100
endm
temp=offset gnbgtbl
rept 319
        dd      temp
temp=temp+2*100
endm

_vidptr         dd      ?               ; ptr to work video page

ressubtbl       dd      80*16-4,80*16-8,0
resbittbl       db      11h,33h,0ffh
resshftbl       db      1,2,1

vpdir           dw      0               ; viewpoint direction (0-319)
vploc           dw      8080h           ; viewpoint loc, Y*256+X

skewptr         dd      gnbgtbl         ; ptr to row to skew
skewcounter     dw      10fh            ; counter between skewing
skewmode        db      0               ; 0=wait, 1=skewing
skewindex       db      3
skewtbl         db      1,-3,5,-3

mtblvpdir       db      5,0,0e7h,0f0h,0, 5,-7,6,-5,9,-6,7,-9
mtblvpy         db      3,0,0c0h,0c0h,0, 3,-1,5,-3,1,-5,1,-3
mtblvpx         db      1,0,060h,0c0h,0, 1,-5,1,-3,3,-1,5,-3

_pagehibyte     db      91h
ovrtcounter     db      ?

;
; CODE
;

;
; Set up draw system
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_gnbg_setup:
        mov dx,3d4h                     ; set up CRTC regs needed
        @outw 3213h
        @outb 0ch

        mov al,'3'                      ; chek for unlimited speed switch
        call _cchekswitch
        jc short setupf1
        mov flipl0m0,9090h
setupf1:

        xor ebx,ebx                     ; check forced switch resolution
        mov al,'0'
setupl0:
        call _cchekswitch
        jnc short setupf0
        inc ebx
        inc eax
        cmp al,'3'
        jb setupl0

        mov al,byte ptr _vrt_timer      ; time draw and set resolution
        mov ovrtcounter,al
        push eax
setupl1:
        cmp al,byte ptr _vrt_timer
        je setupl1
        call _gnbg_draw
        pop eax
        sub al,byte ptr _vrt_timer
        xor ebx,ebx
        cmp al,-3
        adc bl,0
        cmp al,-5
        adc bl,0

setupf0:
        mov al,resbittbl[ebx]
        mov resbit[-1],al
        mov eax,ressubtbl[ebx*4]
        mov ressub[-4],eax
        mov al,resshftbl[ebx]
        mov resshf[-1],al

        ret

;
; Handle all grafix crap for drawing 256x256 buffer to screen
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_gnbg_draw:
        cmp skewmode,0                  ; do skew
        jne short drawf1
        dec skewcounter
        jnz short drawf2
        mov skewcounter,175h
        mov skewmode,1
        mov al,skewindex
        inc al
        and al,3
        mov skewindex,al
        jmp short drawf2
drawf1:
        mov ebx,skewptr
        movzx eax,skewindex
        movsx eax,skewtbl[eax]
        mov cl,80
drawl3:
rept 4
        add [ebx],ax
        add ebx,200
endm
        dec cl
        jnz drawl3
        sub ebx,320*200-2
        cmp ebx,offset gnbgtbl+200
        jb short drawf3
        mov ebx,offset gnbgtbl
        mov skewmode,0
drawf3:
        mov skewptr,ebx
drawf2:

        mov dx,vploc                    ; do movement on X and Y
        mov edi,offset mtblvpy
        call drawr0
        add dh,al
        mov edi,offset mtblvpx
        call drawr0
        add dl,al
        mov vploc,dx
        mov si,dx

        mov edi,offset mtblvpdir        ; do direction spin
        call drawr0
        movsx eax,al
        add ax,vpdir
        cmp ax,320
        jb short drawf0
        jl short drawf0a
        sub ax,320
        jmp short drawf0
drawf0a:
        add ax,320
drawf0:
        mov vpdir,ax
        movzx eax,ax
        lea ebx,[eax*4+offset gnbgtbltbl]

        mov al,ovrtcounter              ; wait for draw safe
drawl0:
        cmp al,byte ptr _vrt_timer
        je drawl0

        movzx edi,_pagehibyte           ; draw bottom of screen
        shl edi,8
        push edi
        add di,100*199
        mov es,_vidsel
        mov ds,_bufsel
        mov al,11h              ; 2baddedh
resbit          label   byte
        mov ecx,-101
drawl1:
        mov dx,3c5h
        out dx,al
        mov ah,80
        mov edx,2
drawl1a:
        mov ebp,cs:[ebx]
        push esi
rept 100
        add si,[ebp]
        add ebp,edx
        movs byte ptr es:[di],byte ptr ds:[si]
        add edi,ecx
endm
        pop esi
        add ebx,16
        add edi,100*100+1
        dec ah
        jnz drawl1a
        sub ebx,80*16-4         ; 2baddedh
ressub          label   dword
        sub edi,80
        db 0c0h,0e0h,1          ; shl al,1 ; 2baddedh
resshf          label   byte
        jnc drawl1
        mov ds,cs:_seldata
        mov es,_seldata

        mov dx,3c5h                     ; mirror to top of screen
        @outb 0fh
        mov dl,0ceh
        @outw 4105h
        pop edi
        add edi,0a0000h
        sub edi,_code32a
        mov _vidptr,edi
        add edi,100*99
        lea esi,[edi+100]
        xor ecx,ecx
        mov bl,10
        mov eax,-180
        mov edx,20
drawl2:
rept 10
        mov cl,80
        rep movsb
        add esi,edx
        add edi,eax
endm
        dec bl
        jnz drawl2
        mov dx,3ceh
        @outw 4005h

        ret
;-----------------------------------------------------------------------------
drawr0:
        mov al,[edi]
        cmp byte ptr [edi+1],0
        jne short drawr0f0
        mov bl,[edi+2]
        dec bl
        jnz short drawr0f1
        mov bl,[edi+4]
        inc bl
        and bl,7
        mov [edi+4],bl
        mov byte ptr [edi+1],1
        mov bl,[edi+3]
drawr0f1:
        mov [edi+2],bl
        ret
drawr0f0:
        movzx ebx,byte ptr [edi+4]
        cmp al,[edi+ebx+5]
        je short drawr0f2
        setl bl
        setg bh
        add al,bl
        sub al,bh
        mov [edi],al
        ret
drawr0f2:
        mov byte ptr [edi+1],0
        ret

;
; Flip video page
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_gnbg_flip:
        mov ah,ovrtcounter
flipl0:
        mov al,byte ptr _vrt_timer
        sub al,ah
        cmp al,3
flipl0m0        label   word
        jb short flipl0
        mov dx,3d5h
        mov al,_pagehibyte
        out dx,al
        mov ah,byte ptr _vrt_timer
        mov ovrtcounter,ah
        xor al,0b0h
        mov _pagehibyte,al
        ret

code32  ends
        end

