        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include vrt.inc
include gnbg.inc
include sc.inc
include grfx.inc
include v.inc

public  _l2start

;
; DATA
;
align 4
posrout         dd      pos0

posrouttbl      dd      pos0,pos1,pos2
POSROUTTBLLEN=($-posrouttbl)/4

routtbl         dd      p00,p20,p10,p30
ROUTTBLLEN=($-routtbl)/4

p0y             dw      251
p0yd            db      -1
p0xi            db      0

align 2
p1x             dw      0
p1xd            db      2
p1y             db      80
p1yd            db      0

align 2
p2x             dw      0
p2xd            db      2
p2i             db      0

routtblindex    db      0
posroutindex    db      0

;
; CODE
;

include l2p0.m
include l2p1.m
include l2p2.m
include l2p3.m

;
pos0:
        mov ebx,offset sincos0
        mov bl,p0xi
        add bl,3
        mov p0xi,bl
        movzx ebx,byte ptr [ebx]
        shr ebx,1
        add ebx,127
        movzx edx,p0y
        movsx eax,p0yd
        add edx,eax
        mov p0y,dx
        jz short pos0f0
        cmp edx,251
        clc
        jne _ret
pos0f0:
        neg al
        mov p0yd,al
        jmp posd
;-----------------------------------------------------------------------------
pos1:
        movzx edx,p1y
        movsx eax,p1yd
        add edx,eax
        inc eax
        cmp dl,200
        jb short pos1f1
        dec eax
        neg eax
pos1f1:
        mov p1y,dl
        mov p1yd,al
        movzx ebx,p1x
        movsx eax,p1xd
        add ebx,eax
        mov p1x,bx
        jz short pos1f0
        cmp ebx,384
        clc
        jne _ret
pos1f0:
        neg al
        mov p1xd,al
        jmp short posd
;-----------------------------------------------------------------------------
pos2:
        movzx ebx,p2x
        movsx eax,p2xd
        add ebx,eax
        mov p2x,bx
        jz short pos2f0
        cmp ebx,384+64
        jae short pos2f0
        mov ecx,offset sincos0
        mov cl,p2i
        add cl,7
        mov p2i,cl
        movzx eax,byte ptr [ecx]
        shr eax,2
        add ebx,eax
        sub ebx,64
        cmp ebx,384
        jbe short pos2f1
        xor ebx,ebx
pos2f1:
        add cl,40h
        mov al,[ecx]
        shr eax,2
        lea edx,[eax+93]
        clc
        ret
pos2f0:
        neg al
        mov p2xd,al
        jmp short posd
;-----------------------------------------------------------------------------
posd:
        movzx eax,posroutindex
        inc eax
        cmp al,POSROUTTBLLEN
        jb short posdf0
        xor al,al
posdf0:
        mov posroutindex,al
        mov eax,posrouttbl[eax*4]
        mov posrout,eax
        stc
        ret

;
setnext:
        movzx eax,routtblindex
        inc eax
        cmp al,ROUTTBLLEN
        jb short setnextf0
        xor eax,eax
setnextf0:
        mov ebx,routtbl[eax*4]
        mov _l2rout,ebx
        mov routtblindex,al
;       xor _l2order,1
        ret

;
_l2start:
        cmp _l2on,0
        je _ret
        mov _l2rout,offset p00
        ret

code32  ends
        end

