    DOSSEG
    .MODEL SMALL
    .STACK 200h
    .CODE
    .386
    ASSUME CS:@CODE, DS:@CODE

    Ideal

GLOBAL InitDrawTriangle:PROC, DrawTriangle:PROC

STRUC XYZstruc
    Xpos    dd  ?       ;must contain Xpos,Ypos,Zpos (all size DD)
    Ypos    dd  ?
    Zpos    dd  ?
ENDS  XYZstruc

STRUC XYstruc
    X       dd  ?
    Y       dd  ?
ENDS  XYstruc

STRUC VpageDescript
    Max     XYstruc <>  ;maximum positions of window
    Min     XYstruc <>  ;minimum positions of window
    WinSize XYstruc <>  ;width & height of window
    Indent  XYstruc <>  ;amount window is adjusted from (0,0)

    Offsets     dw  3 dup (0)
    SCRNWidth   dw  80
    Color       db  ?
ENDS  VpageDescript

    VGAseg      dw  0A000h
    Tri         VpageDescript <>
    CurOffset   dw  ?
    Tri_Slopes  dd  ?,?,?
    Tri_Height  dw  ?           ;number of lines to draw
    Tri_Offs    dw  ?           ;Iy*SCRNwidth + Ix
    SideX       dw  ?,?
    Pointers    dw  ?,?,?       
    Save_Di     dw  ?

    ;di, esi, ebp, dx - must remain the same
MACRO @DrawHorizontalLine
  LOCAL @@Inorder, @@AXisOK, @@DontDoIt, @@CXisOk
    mov     bx,di       ;save off di
    mov     ax,bp
    mov     cx,si
    cmp     ax,cx
    jle     @@InOrder   ;make ax <= cx
    xchg    ax,cx
@@InOrder:
    cmp     cx,[WORD Tri.WinSize.X]
    jle     @@CXisOk
    mov     cx,[WORD Tri.WinSize.X]  ;make sure cx is < window X size
@@CXisOK:
    or      ax,ax
    jns     @@AXisOk
    xor     ax,ax               ;make sure ax is > 0
@@AXisOK:
    sub     cx,ax               ;cx= cx-ax (positive number?)
    or      cx,cx
    js      @@DontDoIt
    add     di,ax               ;di= di+ax
    inc     cx
    mov     al,[Tri.Color]
    rep stosb
@@DontDoIt:
    mov     di,bx       ;restore di
ENDM @DrawHorizontalLine

    ;cs:bx, di, si, bp = ptrs to XYZstruc
    ;  di= upper left corner of view (minX,minY)
    ;  si= lower right corner of view (maxX,maxY)
    ;  bx= X & Y indent for `window'
    ;  bp= Width and height of screen (height is ignored)
    ;dx= offset to page 1
    ;ax= offset to page 2
    ;cx= offset to page 3
    ;
    ;Sets up page and window boundries
    ;
PROC InitDrawTriangle
    push    ds
    push    cs
    pop     ds
    
    mov     [0 + Tri.Offsets],dx         ;save offsets
    mov     [2 + Tri.Offsets],ax
    mov     [4 + Tri.Offsets],cx
    
    mov     eax,[(XYZstruc PTR di).Xpos]    ;save boundries
    mov     [Tri.Min.X],eax
    mov     ecx,[(XYZstruc PTR di).Ypos]
    mov     [Tri.Min.Y],ecx
    mov     edx,[(XYZstruc PTR si).Xpos]
    mov     [Tri.Max.X],edx
    sub     edx,eax                         ;MaxX - MinX
    mov     [Tri.WinSize.X],edx
    mov     edx,[(XYZstruc PTR si).Ypos]
    mov     [Tri.Max.Y],edx
    sub     edx,ecx                         ;MaxY - MinY
    mov     [Tri.WinSize.Y],edx
    
    mov     eax,[(XYZstruc PTR bx).Xpos]    ;save indentions
    mov     [Tri.Indent.X],eax
    mov     eax,[(XYZstruc PTR bx).Ypos]
    mov     [Tri.Indent.Y],eax
    
    mov     eax,[ds:(XYZstruc PTR bp).Xpos] ;save screen width
    mov     [Tri.SCRNWidth],ax
    mov     edx,[Tri.Indent.Y]
    mul     edx
    add     eax,[Tri.Indent.X]
    mov     [Tri_Offs],ax
    
    pop     ds
    ret
ENDP InitDrawTriangle

    ;cs:si, di, bx = ptrs to the XYZstruc's used to display the triangle
    ;dl = color of triangle
    ;bp = page number
PROC DrawTriangle
    pushad
    push    es ds
    mov     ax,cs
    mov     ds,ax
    mov     es,[VGAseg]
    
    mov     [Tri.Color],dl
    add     bp,bp
    mov     ax,[cs:bp + Tri.Offsets]
    mov     [CurOffset],ax
    
    mov     eax,[Tri.Min.X]
    mov     ecx,[Tri.Min.Y]
    sub     [(XYZstruc PTR si).Xpos],eax    ;change to positions relative to 
    sub     [(XYZstruc PTR si).Ypos],ecx    ; upper left corner
    sub     [(XYZstruc PTR di).Xpos],eax
    sub     [(XYZstruc PTR di).Ypos],ecx
    sub     [(XYZstruc PTR bx).Xpos],eax
    sub     [(XYZstruc PTR bx).Ypos],ecx
    
    mov     eax,[(XYZstruc PTR si).Ypos]    ;sort by Ypos
    mov     ecx,[(XYZstruc PTR di).Ypos]
    mov     edx,[(XYZstruc PTR bx).Ypos]

    cmp     eax,ecx                         ;only 3 CMP's are needed
    jle     @@eaxLTecx
    xchg    eax,ecx
    xchg    si,di
@@eaxLTecx:
    cmp     ecx,edx
    jle     @@ecxLTedx
    xchg    ecx,edx
    xchg    di,bx
@@ecxLTedx:
    cmp     eax,ecx
    jle     @@eaxLTecx2
    xchg    eax,ecx
    xchg    si,di
@@eaxLTecx2:
    mov     [pointers],si       ;save off pointers incase I need 'em later
    mov     [pointers+2],di
    mov     [pointers+4],bx
    
    mov     eax,[Tri.WinSize.X]
    cmp     [(XYZstruc PTR si).Xpos],0
    jge     @@NotToLeft
    cmp     [(XYZstruc PTR di).Xpos],0
    jge     @@NotToLeft
    cmp     [(XYZstruc PTR bx).Xpos],0
    jge     @@NotToLeft
    jmp     @@AllDoneTriangle
@@NotToLeft:
    cmp     [(XYZstruc PTR si).Xpos],eax
    jl      @@NotToRight
    cmp     [(XYZstruc PTR di).Xpos],eax
    jl      @@NotToRight
    cmp     [(XYZstruc PTR bx).Xpos],eax
    jl      @@NotToRight
    jmp     @@AllDoneTriangle
@@NotToRight:
    mov     eax,[(XYZstruc PTR si).Ypos]    ;sort by Ypos
    
    cmp     edx,eax             ;see if we have a null triangle (no height)
    je      @@AllDoneTriangle
    cmp     eax,ecx
    je      @@TheresNoTop
    or      eax,eax             ;see if eax is negative (above boundry)
    jns     @@TopIsVisible
    or      ecx,ecx             ;test if middle is above boundry
    jns     @@MiddleIsVisible
    or      edx,edx             ;is the whole triangle above boundry?
    jns     @@BottomIsVisible   
    jmp     @@AllDoneTriangle   ;Triangle is not in window
    
@@TheresNoTop:
    or      ecx,ecx             ;is the middle above boundry?
    jns     @@DoChop
    or      edx,edx             ;is the whole triangle above boundry?
    jns     @@BottomIsVisible
    jmp     @@AllDoneTriangle   ;Triangle is not in window
@@DoChop:
    mov     ecx,edx
    sub     ecx,eax             ;Y13 = Y3 - Y1
    mov     eax,[(XYZstruc PTR bx).Xpos]
    sub     eax,[(XYZstruc PTR si).Xpos]    ;X13 = X3 - X1
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes],eax    ;hi 16bit=integer, low 16bits=precision
    
    push    [WORD (XYZstruc PTR si).Xpos]
    push    [WORD (XYZstruc PTR di).Xpos]
    
    mov     di,[Tri_Offs]
    mov     ax,[WORD (XYZstruc PTR si).Ypos]
    mov     dx,[Tri.SCRNwidth]
    mul     dx
    add     di,ax
    
    pop     si
    pop     bp
    jmp     @@InitBottom
    Jmp     @@AllDoneTriangle
    
@@TopIsVisible:                 ;figure slopes for long and top sides-no clip
    cmp     eax,[Tri.WinSize.Y] ;see if triangle is off bottom
    jge     @@AllDoneTriangle
    mov     ecx,edx
    sub     ecx,eax             ;Y13 = Y3 - Y1
    mov     eax,[(XYZstruc PTR bx).Xpos]
    sub     eax,[(XYZstruc PTR si).Xpos]    ;X13 = X3 - X1
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes],eax    ;hi 16bit=integer, low 16bits=precision
    
    mov     ecx,[(XYZstruc PTR di).Ypos]
    sub     ecx,[(XYZstruc PTR si).Ypos]    ;Y12 = Y2 - Y1
    mov     eax,[(XYZstruc PTR di).Xpos]
    sub     eax,[(XYZstruc PTR si).Xpos]    ;X12 = X2 - X1
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes+4],eax  ;hi 16bit=integer, low 16bits=precision
    
    mov     ax,[WORD (XYZstruc PTR si).Xpos]
    mov     [SideX],ax
    mov     [SideX+2],ax
    
    mov     ax,[WORD (XYZstruc PTR di).Ypos]    ;h= y2 - y1
    cmp     ax,[WORD Tri.WinSize.Y]
    jle     @@OkHeight1
    mov     ax,[WORD Tri.WinSize.Y]
@@OkHeight1:
    sub     ax,[WORD (XYZstruc PTR si).Ypos]
    mov     [Tri_Height],ax
    
    mov     di,[Tri_Offs]
    mov     ax,[WORD (XYZstruc PTR si).Ypos]
    mov     dx,[Tri.SCRNwidth]
    mul     dx
    add     di,ax
    
    Jmp     @@StartDoingTop
    
@@MiddleIsVisible:              ;get slopes for long & top w/ clip
    sub     edx,eax             ;Y13 = Y3 - Y1
    mov     ecx,edx
    mov     eax,[(XYZstruc PTR bx).Xpos]
    sub     eax,[(XYZstruc PTR si).Xpos]    ;X13 = X3 - X1
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes],eax    ;hi 16bit=integer, low 16bits=precision
    
    mov     ecx,[(XYZstruc PTR di).Ypos]
    sub     ecx,[(XYZstruc PTR si).Ypos]    ;Y12 = Y2 - Y1
    mov     eax,[(XYZstruc PTR di).Xpos]
    sub     eax,[(XYZstruc PTR si).Xpos]    ;X12 = X2 - X1
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes+4],eax  ;hi 16bit=integer, low 16bits=precision
    
    mov     eax,[Tri_Slopes]                ;X=x1 + Slope13 * (-y1)
    mov     edx,[(XYZstruc PTR si).Ypos]
    neg     edx
    imul    edx
    shr     eax,16
    add     ax,[WORD (XYZstruc PTR si).Xpos]
    mov     [SideX],ax
    
    mov     eax,[Tri_Slopes+4]              ;X=x1 + Slope12 * (-y1)
    mov     edx,[(XYZstruc PTR si).Ypos]
    neg     edx
    imul    edx
    shr     eax,16
    add     ax,[WORD (XYZstruc PTR si).Xpos]
    mov     [SideX+2],ax
    
    mov     ax,[WORD (XYZstruc PTR di).Ypos] ;h= y2 -0
    cmp     ax,[WORD Tri.WinSize.Y]
    jle     @@OkHeight2
    mov     ax,[WORD Tri.WinSize.Y]
@@OkHeight2:
    mov     [Tri_Height],ax
    
    mov     di,[Tri_Offs]       ;since Ypos = 0
    
    Jmp     @@StartDoingTop
    
@@BottomIsVisible:              ;find slopes for long and bottom & clip
    sub     edx,eax             ;Y13 = Y3 - Y1
    mov     ecx,edx
    mov     eax,[(XYZstruc PTR bx).Xpos]
    sub     eax,[(XYZstruc PTR si).Xpos]    ;X13 = X3 - X1
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes],eax    ;hi 16bit=integer, low 16bits=precision
    
    mov     ecx,[(XYZstruc PTR bx).Ypos]
    sub     ecx,[(XYZstruc PTR di).Ypos]    ;Y23 = Y3 - Y2
    mov     eax,[(XYZstruc PTR bx).Xpos]
    sub     eax,[(XYZstruc PTR di).Xpos]    ;X23 = X3 - X2
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes+8],eax  ;hi 16bit=integer, low 16bits=precision
    
    mov     eax,[Tri_Slopes]                ;X=x1 + Slope13 * (-y1)
    mov     edx,[(XYZstruc PTR si).Ypos]
    neg     edx
    imul    edx
    shr     eax,16
    add     ax,[WORD (XYZstruc PTR si).Xpos]
    mov     [SideX],ax
    
    mov     eax,[Tri_Slopes+8]              ;X=x2 + Slope23 * (-y2)
    mov     edx,[(XYZstruc PTR di).Ypos]
    neg     edx
    imul    edx
    shr     eax,16
    add     ax,[WORD (XYZstruc PTR di).Xpos]
    mov     [SideX+2],ax
    
    mov     ax,[WORD (XYZstruc PTR bx).Ypos] ;h= y3 -0
    cmp     ax,[WORD Tri.WinSize.Y]
    jle     @@OkHeight3
    mov     ax,[WORD Tri.WinSize.Y]
@@OkHeight3:
    mov     [Tri_Height],ax
    
    mov     di,[Tri_Offs]
    xor     esi,esi
    xor     ebp,ebp
    mov     si,[SideX+2]
    mov     bp,[SideX]
    
    Jmp     @@StartDoingBottom
    
    ;at this point, height is set, & the sidex's are set up
    ;di = offset to (0,y) to start drawing at
@@StartDoingTop:
    mov     dx,[Tri_Height]
    xor     ebp,ebp             ;ebp is the long side
    xor     esi,esi
    mov     bp,[SideX]
    mov     si,[SideX+2]
    or      dx,dx
    js      @@AllDoneTriangle   ;if we have negative height...
    je      @@InitBottom
@@TopLoop:
    ror     ebp,16
    add     ebp,[Tri_Slopes]
    ror     ebp,16
    ror     esi,16
    add     esi,[Tri_Slopes+4]
    ror     esi,16
    @DrawHorizontalLine
    add     di,[Tri.ScrnWidth]
    dec     dx
    jne     @@TopLoop
    
@@InitBottom:
    ;Init bottom half now - save ebp,esi,di
    mov     [Save_di],di
    mov     di,[Pointers + 2]
    mov     bx,[Pointers + 4]
    
    mov     ecx,[(XYZstruc PTR di).Ypos]
    cmp     ecx,[Tri.WinSize.Y]
    jge     @@AllDoneTriAngle
    sub     ecx,[(XYZstruc PTR bx).Ypos]    ;Y23 = -(-Y3 + Y2)
    je      @@AllDoneTriangle
    neg     ecx
    mov     eax,[(XYZstruc PTR bx).Xpos]
    sub     eax,[(XYZstruc PTR di).Xpos]    ;X23 = X3 - X2
    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    ecx
    mov     [Tri_Slopes+8],eax  ;hi 16bit=integer, low 16bits=precision
    
    xor     esi,esi
    mov     si,[WORD (XYZstruc PTR di).Xpos]
    
    mov     eax,[(XYZstruc PTR bx).Ypos]
    cmp     eax,[Tri.WinSize.Y]
    jle     @@YOk2
    mov     eax,[Tri.WinSize.Y]
@@YOk2:
    sub     eax,[(XYZstruc PTR di).Ypos]
    mov     [Tri_Height],ax
    mov     di,[Save_di]
@@StartDoingBottom:
    mov     dx,[Tri_Height]
    or      dx,dx
    js      @@AllDoneTriangle
    je      @@AllDoneTriangle
@@TopLoop2:
    ror     ebp,16
    add     ebp,[Tri_Slopes]
    ror     ebp,16
    ror     esi,16
    add     esi,[Tri_Slopes+8]
    ror     esi,16
    @DrawHorizontalLine
    add     di,[Tri.ScrnWidth]
    dec     dx
    jne     @@TopLoop2
    
@@AllDoneTriangle:
    pop     ds es
    popad
    ret
ENDP DrawTriangle

    END
