    DOSSEG
    .MODEL SMALL
    .STACK 200h
    .CODE
    .386
    ASSUME CS:@CODE, DS:@CODE

    Ideal

GLOBAL InitDrawTriangle:PROC, DrawTriangle:PROC
GLOBAL PrintWord:PROC

STRUC XYZstruc
    Xpos    dd  ?       ;must contain Xpos,Ypos,Zpos (all size DD)
    Ypos    dd  ?
    Zpos    dd  ?
ENDS  XYZstruc

STRUC XYstruc
    X       dd  ?
    Y       dd  ?
ENDS  XYstruc

ULCorner XYZstruc   <0,0>
LRCorner XYZstruc   <200,100>
Indent   XYZstruc   <50,50>        ;amt to indent window from (0,0)
WHwindow XYZstruc   <320,200>       ;size of screen
Pages       dw      0,0,0
DaColor     db      1

MAXX    =   430
MINX    =   -130
MAXY    =   230
MINY    =   -130

DaTriangle  XYZstruc <-10,-10>,<49,30>,<20,49>
DaVels      XYZstruc <-1,-2>,<3,-1>,<2,1>

    ;** InitDrawTriangle **
    ;cs:bx, di, si, bp = ptrs to XYZstruc
    ;  di= upper left corner of view (minX,minY)
    ;  si= lower right corner of view (maxX,maxY)
    ;  bx= X & Y indent for `window'
    ;  bp= Width and height of screen (height is ignored)
    ;dx= offset to page 1
    ;ax= offset to page 2
    ;cx= offset to page 3
    ;
    ;Sets up page and window boundries
    
    ;** DrawTriangle **
    ;cs:si, di, bx = ptrs to the XYZstruc's used to display the triangle
    ;dl = color of triangle
    ;bp = page number
PROC DrawBox
    pusha
    push    es ds
    mov     ax,0a000h
    mov     es,ax
    mov     ax,cs
    mov     ds,ax

    mov     di,[WORD Indent.Ypos]
    dec     di
    imul    di,320
    add     di,[WORD Indent.Xpos]
    dec     di
    mov     cx,[WORD LRCorner.Xpos]
    sub     cx,[WORD ULCorner.Xpos]
    add     cx,2
    push    cx
    mov     al,7
    rep     stosb
    
    mov     di,[WORD Indent.Ypos]
    add     di,[WORD LRCorner.Ypos]
    sub     di,[WORD ULcorner.Ypos]
    imul    di,320
    add     di,[WORD Indent.Xpos]
    dec     di
    pop     cx
    mov     al,7
    rep     stosb

    mov     di,[WORD Indent.Ypos]
    dec     di
    imul    di,320
    add     di,[WORD Indent.Xpos]
    push    di
    dec     di
    mov     cx,[WORD LRCorner.Ypos]
    sub     cx,[WORD ULCorner.Ypos]
    add     cx,2
    push    cx
    mov     al,7
@@DrLoop:
    mov     [es:di],al
    add     di,320
    dec     cx
    jne     @@DrLoop
    
    pop     cx
    pop     di
    inc     di
    add     di,[WORD LRCorner.Xpos]
    sub     di,[WORD ULcorner.Xpos]
    mov     al,7
@@DrLoop2:
    mov     [es:di],al
    add     di,320
    dec     cx
    jne     @@DrLoop2

    pop     ds es
    popa
    ret
ENDP DrawBox

;DaTriangle  XYZstruc <-10,-10>,<49,30>,<20,49>
;DaVels      XYZstruc <-1,-1>,<1,-1>,<2,1>

PROC MoveTri
    pusha
    push    ds

    mov     bx,0
@@Zloop:
    mov     eax,[bx+DaVels.Xpos]
    add     [bx+DaTriangle.Xpos],eax
    cmp     [bx+DaTriangle.Xpos],MAXX
    jle     @@NotMaxX
    mov     [bx+DaTriangle.Xpos],MAXX
    neg     [bx+DaVels.Xpos]
@@NotMaxX:
    cmp     [bx+DaTriangle.Xpos],MINX
    jge     @@NotMinX
    mov     [bx+DaTriangle.Xpos],MINX
    neg     [bx+DaVels.Xpos]
@@NotMinX:
    mov     eax,[bx+DaVels.Ypos]
    add     [bx+DaTriangle.Ypos],eax
    cmp     [bx+DaTriangle.Ypos],MAXY
    jle     @@NotMaxY
    mov     [bx+DaTriangle.Ypos],MAXY
    neg     [bx+DaVels.Ypos]
@@NotMaxY:
    cmp     [bx+DaTriangle.Ypos],MINY
    jge     @@NotMinY
    mov     [bx+DaTriangle.Ypos],MINY
    neg     [bx+DaVels.Ypos]
@@NotMinY:
    add     bx,size XYZstruc
    cmp     bx, 3*(size XYZstruc)
    jb      @@Zloop

    pop     ds
    popa
    ret
ENDP MoveTri

PROC PrintStuff
    pusha
    mov     ah,2
    mov     dx,0
    int     10h

    mov     ax,[WORD DaTriangle.Ypos]
    stc
    call    PrintWord
    mov     ax,[WORD (size XYZstruc) + DaTriangle.Ypos]
    stc
    call    PrintWord
    mov     ax,[WORD 2*(size XYZstruc)+DaTriangle.Ypos]
    stc
    call    PrintWord
    
    mov     ah,2
    mov     dx,100h
    int     10h

    mov     ax,[WORD DaTriangle.Xpos]
    stc
    call    PrintWord
    mov     ax,[WORD (size XYZstruc) + DaTriangle.Xpos]
    stc
    call    PrintWord
    mov     ax,[WORD 2*(size XYZstruc)+DaTriangle.Xpos]
    stc
    call    PrintWord

    popa
    ret
ENDP

PROC DrawDot
    pusha
    push    es ds
    mov     ax,0a000h
    mov     es,ax
    mov     ax,cs
    mov     ds,ax
    
    mov     di,[WORD DaTriangle.Ypos]
    add     di,[WORD Indent.Ypos]
    imul    di,320
    add     di,[WORD DaTriangle.Xpos]
    add     di,[WORD Indent.Xpos]
    mov     [BYTE es:di],2
    
    mov     di,[WORD (size XYZstruc) + DaTriangle.Ypos]
    add     di,[WORD Indent.Ypos]
    imul    di,320
    add     di,[WORD (size XYZstruc) + DaTriangle.Xpos]
    add     di,[WORD Indent.Xpos]
    mov     [BYTE es:di],2
    
    mov     di,[WORD 2*(size XYZstruc) + DaTriangle.Ypos]
    add     di,[WORD + Indent.Ypos]
    imul    di,320
    add     di,[WORD 2*(size XYZstruc) + DaTriangle.Xpos]
    add     di,[WORD + Indent.Xpos]
    mov     [BYTE es:di],2
    pop     ds es
    popa
    ret
ENDP


START:
    mov     ax,cs
    mov     ds,ax
    mov     ax,13h
    int     10h
    cld

    mov     di,offset ULcorner
    mov     si,offset LRcorner
    mov     bx,offset Indent
    mov     bp,offset WHwindow
    mov     dx,[Pages]
    mov     ax,[Pages+2]
    mov     cx,[Pages+4]
    call    InitDrawTriangle
    call    DrawBox
MainLoop:
    call    MoveTri
    call    PrintStuff

    mov     si,offset DaTriangle
    mov     di,si
    add     di,size XYZstruc
    mov     bx,di
    add     bx,size XYZstruc
    mov     dl,[DaColor]
    mov     bp,0
    call    DrawTriangle
    inc     [DaCOlor]

    call    DrawBox

    mov     ax,0a000h
    mov     es,ax
    

    mov     ah,1
    int     16h
    jz      MainLoop
;    mov     ah,0
;    int     16h
;    cmp     al,27
;    jne     MainLoop

    mov     ah,0
    int     16h
    mov     ax,3
    int     10h
    mov     ax,4c00h
    int     21h

    END START
