 /***************************************************************************
 *  NAMETEST.C								   *
 *	This file is used to demonstrate usage of Name Management Services *
 *									   *
 *  Usage:								   *
 *	Nametest < name to be add and deleted> <lan adaptor number>	   *
 *	e.g								   *
 *		Nametest "Foor Jr" 0					   *
 *									   *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <common.h>
#include <namesrv.h>

void CopyToBuffer ( char *pchDest , char * pchSrc);

int main ( int argc, char **argv)
{

    char chNameBuffer [ NCBNAMSZ ];
    unsigned char   ucLana;
    unsigned char   ucNameNum;
    unsigned char   ucRc;
    int i;

    if (argc < 2 )
    {
	printf ("Usage: NameTest <name to be added/del> [<lana>]\n");
	exit (1);

    }
    CopyToBuffer( chNameBuffer, argv[1]);

    printf("Name: [");
    for ( i=0; i < NCBNAMSZ; i++)
	printf ("%c", chNameBuffer[i]);
    printf ("]\n");

    /* What is the LAN Adaptor number */
    if (argc >= 3)
	ucLana = (unsigned  char ) atoi ( argv [2] );
    else
	ucLana = 0;
    printf ( "LANA: [%d] \n",	 ucLana);

    /* Initialize in case of OS/2 */
    NetInit( ucLana);

    /* Add a Name */
    ucRc =     AddName ( chNameBuffer,
			 ADD_UNIQUE_NAME,
			 ucLana,
			 &ucNameNum
		       );

    printf("AddName:: RC: [%x] NameNumber: [%x]\n", ucRc, ucNameNum);

    if (ucRc )
	return NetCleanUp (1);

    /* Find the Name  */

    ucRc =     FindName ( chNameBuffer,
			  ucLana
			);

    printf("FindName:: RC: [%x] \n", ucRc);

    /* Delete the Name */
    ucRc =     DelName ( chNameBuffer,
			 ucLana,
			 ucNameNum
		       );

    printf("DelName:: RC: [%x] \n", ucRc);

    return NetCleanUp ( 0 );
}
