/***************************************************************************
 *  TTy.C								   *
 *	This file shows the usage of NetBIOS datagram commands. 	   *
 *	The program must be run two machines who wish to communicate.	   *
 *	In this sample program, one side must receive datgrams while the   *
 *	while the other side sends datagrams. They can of course change    *
 *	their roles. The program, of course, is not very user friendly	   *
 *	and can be improved by implementing asynchronous send and receives.*
 *	This will give user the ability to receive and send datagram at the*
 *	same  time.							   *
 *									   *
 *									   *
 * Sample Usage:							   *
 *	Machine TALKER		    Machine LISTENER			   *
 *	--------------		    ----------------			   *
 *	 c:>TTy talker listener	    c:>TTy listener talker		   *
 *									   *
 *  History:   Alok Sinha  October, 1991    Created			   *
 *									   *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#include <common.h>
#include <namesrv.h>
#include <datasrv.h>


#define  LINE_SIZE 80
#define  SEND	   1
#define  RECEIVE   2
#define  ESC	   0x1B
#define  NEWLINE   0x0D
#define  _EOF_	   0x1A

void CopyToBuffer ( char *pchDest , char *pchSrc);
void SendReceive  ( char ucLana, char usNameNum, char * pchRemoteName);
int  GetLine	  ( char *pchBuffer);

int main ( int argc, char **argv)
{

    char chLocalNameBuffer  [ NCBNAMSZ ];
    char chRemoteNameBuffer [ NCBNAMSZ ];
    unsigned char   ucLana;
    unsigned char   ucNameNum;
    unsigned char   ucRc;


    if (argc < 3 )
    {
	printf ("Usage: TTy <local name> <remote name> [<lana>]\n");
	exit (1);

    }
    CopyToBuffer( chLocalNameBuffer, argv[1]);
    CopyToBuffer( chRemoteNameBuffer, argv[2]);

    printf("Local Name:  [%16.16s]\n", chLocalNameBuffer);

    printf("Remote Name: [%16.16s]\n", chRemoteNameBuffer);


    /* What is the LAN Adaptor number */
    if (argc >= 4)
	ucLana = (unsigned  char ) atoi ( argv [3] );
    else
	ucLana = 0;
    printf ( "LANA: [%d] \n",	 ucLana);

    /* Initialize in case of OS/2 */
    NetInit( ucLana);


    /* Add a Name */
    ucRc =     AddName ( chLocalNameBuffer,
			 ADD_UNIQUE_NAME,
			 ucLana,
			 &ucNameNum
		       );

    printf("AddName:: RC: [%x] NameNumber: [%x]\n", ucRc, ucNameNum);

    if (ucRc )
	return NetCleanUp (1);

    SendReceive( ucLana, ucNameNum, chRemoteNameBuffer);

    /* Delete the Name */
    ucRc =     DelName ( chLocalNameBuffer,
			 ucLana,
			 ucNameNum
		       );

    printf("DelName:: RC: [%x] \n", ucRc);

    return NetCleanUp (0);
}


/*
 * FUNCTION    :: SendReceive()
 * PARAMETERS  ::
 *	 [in] ucLana	    :- LAN adaptor numner over which to communicate.
 *	 [in] ucNameNum	    :- Name number associated with local name.
 *	 [in] pchRemoteName :- char pointer to a NetBIOS name of remote
 *			       listener/receiver
 *
 * RETURN VALUE:
 *		NONE.
 * Comments:
 *	    Provides a very simple one-way TTy service between a local
 *	    name and remote name.
 *
 */

void SendReceive ( char ucLana, char ucNameNum, char * pchRemoteName)
{
    int mode;
    int ch;
    char	chLine [ LINE_SIZE ];
    unsigned	short	usLineSize, i;
    unsigned	char	ucRc;

    mode = RECEIVE;
    printf("Default mode is Receive.\n");
    printf("Press ESC to change  mode, Else press enter.\n");
    printf("Press <cntrl><z> to quit. \n");

    ch = getch ();
    if (ch==_EOF_)
	return ;
    if (ch==ESC)
	mode = SEND;

    do
    {
	switch (mode)
	{
	    case SEND:
		printf("Send: ");
		ch = GetLine (chLine);

		printf("\n");

		if (ch==ESC)
		    { mode = RECEIVE; break; }

		if (ch==_EOF_)
		{
		    chLine [ 0 ]= -1;
		    chLine [ 1 ]= '\0';
		}

		ucRc = SendDatagram ( pchRemoteName,
				       ucLana,
				       ucNameNum,
				       chLine,
				       strlen(chLine)
				    );
		if (ch==_EOF_)
		    return;

		if (ucRc)
			printf("Error Sending Datagram: RC: [%x]\n", ucRc);

	    break;

	    case RECEIVE:
		printf("Receiving: ");

		usLineSize = LINE_SIZE;
		ucRc = ReceiveDatagram ( ucLana,
					 ucNameNum,
					 chLine,
					 &usLineSize
				       );
		if (ucRc)
			printf("Error Receiving Datagram: RC: [%x]\n", ucRc);
		else
		{
		    if (chLine [ 0 ]==-1)
		    {
               printf("Remote user Hang Up\n");
               return;
		    }

		    for (i= 0; i< usLineSize; i++)
                printf("%c", chLine [i]);
		    printf("\n");
		}

		/*
		 * check if user wants to get out or change mode. Yes, this
		 * is definitely boring as receiver has to keep hiting
		 * the key board. This problem is solved by implementing
		 * async. receive.
		 */
		ch = getch ();
		if (ch==_EOF_)
		    return ;
		if (ch==ESC)
		   mode = SEND;
	    break;
	}

    } while (ch != _EOF_);


}
/*
 * FUNCTION    :: GetLine()
 * PARAMETERS  ::
 *	 [in/out] pchBuffer:- char pointer to a buffer which will receive
 *			      user input.
 *
 * RETURN VALUE:
 *		The last character typed by the user.
 * Comment:
 *		Allows user to type in a LINE_SIZE big line or simply
 *		a ESC or <control><z>
 */


int GetLine ( char *pchBuffer)
{
    int ch, index;

    index = 0 ;
    do
    {
	ch = getch();
	if ((ch == ESC) || (ch == _EOF_))
	    return ch;

	putch( ch );
	pchBuffer [index++] = ch;

	if (ch == NEWLINE)
	{
	    pchBuffer [index] = '\0';
	    return ch;
	}

    } while ( index < LINE_SIZE);

}
