(**********************************************************************)
(*  NetFix is a program that will allow Turbo Pascal 6.0 to run from  *)
(*  a network drive.  The program expects TURBO.EXE to be present in  *)
(*  the current directory.  The program then will open TURBO.EXE find *)
(*  the patch location, verify that the current information is        *)
(*  correct,  make the patch and then close TURBO.EXE                 *)
(**********************************************************************)
Program NetFix;

Uses CRT;

Type
  TPatch = Array[1..8] of Byte;

Const
  OldValue: TPatch = ($B8, $02, $3D, $50, $B8, $00, $04, $50);
  NewValue: TPatch = ($B8, $00, $3D, $50, $B8, $00, $04, $50);

  OldSum = $253;
  NewSum = $251;
  TurboSize = 325397;

Procedure Error(S:String);
Begin
  Writeln(S,'  Please correct.');
  Halt;
End;

Var
  Turbo: File;
  I: Byte;
  Sum: Longint;
  PatchValue: TPatch;

Begin
  Sum := 0;
  For I := 1 to SizeOf(OldValue) do
    Sum := Sum + OldValue[I];
  If Sum <> OldSum then Error('OldValue or OldSum not correct.');
  Sum := 0;
  For I := 1 to SizeOf(NewValue) do
    Sum := Sum + NewValue[I];
  If Sum <> NewSum then Error('NewValue or NewSum not correct.');
  Assign(Turbo,'TURBO.EXE');
  {$I-}
  Reset(Turbo,1);
  {$I+}
  If IOResult <> 0 then Error('TURBO.EXE not in current directory.');
  If FileSize(Turbo) <> TurboSize then
    Error('Size of TURBO.EXE is not correct.  Check Reset and TurboSize.');
  Seek(Turbo,$12D38);
  BlockRead(Turbo, PatchValue, Sizeof(PatchValue));
  For I := 1 to Sizeof(OldValue) do
    If PatchValue[I] <> OldValue[I] then
      Error('TURBO.EXE has been patched or is not 6.0');
  Seek(Turbo,$12D38);
  {$I-}
  BlockWrite(Turbo, NewValue, Sizeof(NewValue));
  {$I+}
  If IOResult <> 0 then Error('TURBO.EXE is write protected or read only.');
  Close(Turbo);
  Writeln('TURBO.EXE successfully patched for networks.');
End.