unit Rexec;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, Sockets;

type
  TRExecFrm = class(TForm)
    Label3: TLabel;
    efUserid: TEdit;
    Label1: TLabel;
    efIPaddr: TEdit;
    efCommand: TEdit;
    Label2: TLabel;
    efPassword: TEdit;
    Label4: TLabel;
    Memo1: TMemo;
    pbRexec: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Sockets1: TSockets;
    procedure pbRexecClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Sockets1DataAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1SessionClosed(Sender: TObject; Socket: Word);
    procedure Sockets1SessionConnected(Sender: TObject; Socket: Word);
  private
  public
  end;

var
  RExecFrm: TRExecFrm;
  line: string;

implementation

{$R *.DFM}


procedure TRExecFrm.pbRexecClick(Sender: TObject);
begin
  line := '';
  if (efUserid.text = '') or (efPassword.Text = '') or
     (efIPaddr.Text = '') or (efCommand.Text = '') then
    begin
      Application.MessageBox('Please enter all required fields!', 'REXEC ERROR',
         mb_OKCancel + mb_DefButton1);
      exit;
    end;
  Memo1.Clear;
  Sockets1.IPAddr := efIPaddr.Text;
  Sockets1.Port := 'exec';
  Sockets1.SConnect;
end;


procedure TRExecFrm.Exit1Click(Sender: TObject);
begin
  Close
end;

procedure TRExecFrm.Sockets1DataAvailable(Sender: TObject; Socket: Word);
var
  len: integer;
  Buff: string;
  i: integer;
begin
  Buff := Sockets1.Text;
  len := Length(Buff);
  if len > 1 then
  begin
    for i := 1 to len do
    begin
      if Buff[i] = #10 then
      begin
        Memo1.Lines.Add(line);
        line := '';
      end
      else
        { rexec includes terminating null as part of the length }
        if Buff[i] <> #0 then
          line := line + Buff[i];
    end
  end;
end;

procedure TRExecFrm.Sockets1SessionClosed(Sender: TObject; Socket: Word);
begin
  Sockets1.SClose;
end;

procedure TRExecFrm.Sockets1SessionConnected(Sender: TObject;
  Socket: Word);
begin
  { We can't use Sockets1.Text := ... here because REXECD expects a null at
    the end of the userid, password, and command }
  Sockets1.SSend(Sockets1.SocketNumber,'',1);
  Sockets1.SSend(Sockets1.SocketNumber,efUserid.Text + #0,
    Length(efUserid.Text)+1);
  Sockets1.SSend(Sockets1.SocketNumber,efPassword.Text + #0,
    Length(efPassword.Text)+1);
  Sockets1.SSend(Sockets1.SocketNumber,efCommand.Text + #0,
    Length(efCommand.Text)+1);

end;

end.
