
{ animation unit for BGI256 demo program }
{ as of 24 April 1993 }
unit AniSub;
interface

uses crt,graph,Wrmode;

procedure CreateSaucer(SaucerSize:word);
procedure DoSaucer;

TYPE  ByteArray = array[0..64000] of byte;

var R,Xr,Yr : Integer;
    MoveDelay : word;
    StartX,StartY,Step : integer;
    Rx,Ry : integer;
    Ax,Ay,X1,Y1,X2,Y2 : integer;
    AniSize : word;
    P,PI,PO,PM:^ByteArray;
    ArcCoords : ArcCoordsType;
    Xasp,Yasp:word;
    MaxColor : word;
    TSIZE : WORD;
    OldX,OldY:integer;
    done : boolean;
    CH : char;

CONST UserFillPattern : FillPatternType = ($AA,$55,$AA,$55,$AA,$55,$AA,$55);

const QuickAnimate : boolean = false;
      ShowArea = false;

implementation

function Limit(What,Low,High:integer):integer;
begin
  if What < Low then Limit := Low
  else if What > High then Limit := High
  else Limit := What;
end;


procedure MakeSaucerImage(C0,C1,C2,C3,C4,C5,C6:word);
begin
  setLineStyle(SolidLn,0,1);
  SetFillStyle(SolidFill,C0);
  Bar(x1,y1,x2,y2);
  SetColor(C1); {lightCyan}
  Ellipse(StartX, StartY-(Ry div 8), 190, 357, r, r div 4);
  Ellipse(StartX, StartY, 0, 360, r, (r div 2));
  GetArcCoords(ArcCoords);
  SetColor(C2);   {lightblue}
  Line(StartX+(Rx div 3), StartY-((Ry*3)div 8), StartX+(Rx div 2), StartY-((Ry*3)div 4));
  Line(StartX-(Rx div 3), StartY-((Ry*3)div 8), StartX-(Rx div 2), StartY-((Ry*3)div 4));
  SetColor(C3); {lightRed}
  Circle(StartX+(Rx div 2), StartY-((Ry*3)div 4), 2);
  Circle(StartX-(Rx div 2), StartY-((Ry*3)div 4), 2);
  SetColor(C4);  {White}
  PutPixel(StartX+(Rx div 2), StartY-((Ry*3)div 4), C4);
  PutPixel(StartX-(Rx div 2), StartY-((Ry*3)div 4), C4);
  SetWriteMode(FillMode+BorderFill);
  SetWriteMode(FillMode+AutoFill);
  SetFillPattern(UserFillPattern, C5);  {Cyan}
  FloodFill(StartX, StartY+(Ry div 3)+2, C6); {LightCyan}
end;


procedure CreateSaucer(SaucerSize:word);
var BadSize : boolean;
    i : integer;
    Xasp,Yasp : word;
begin
  R := SaucerSize;
  MoveDelay := 200;
  StartX := GetMaxX div 2;
  StartY := GetMaxY div 2;
  GetAspectRatio(Xasp,Yasp);
  BadSize := true;
  while BadSize do
  begin
    Rx := r;
    Ry := (r*Xasp) div Yasp;
    X1 := StartX-rx-1;
    Y1 := StartY-ry-1;
    X2 := StartX+rx+1;
    Y2 := StartY+ry+1;
    if (longint(X2 - X1) * longint(Y2 - Y1) < 65500) and
       (X1 > 0) and (X2 < GetMaxX) and
       (Y1 > 0) and (Y2 < GetMaxY) then
      BadSize := false
    else
      R := 20;
  end;
  Xr := X2-X1;
  Yr := Y2-Y1;
  AniSize := ImageSize(x1,y1,x2,y2);
  GetMem(P,AniSize);
  GetMem(PI,AniSize);
  GetMem(PO,AniSize);
  SetWriteMode(MiscCommand+SetGetImageReadOnly);
  GetImage(x1,y1,x2,y2,P^);
  if not(QuickAnimate) then
  begin
    GetMem(PM,AniSize);
    MakeSaucerImage(White,MaxColor,MaxColor,MaxColor,MaxColor,MaxColor,MaxColor);
    GetImage(x1,y1,x2,y2,PM^);
  end;
  MakeSaucerImage(Black,LightCyan,LightBlue,LightRed,White,Cyan,LightCyan);
  GetImage(x1,y1,x2,y2,PI^);
  SetColor(yellow);
  Rectangle(x1,y1,x2,y2);
  Tsize := MaxAvail;
  PutImage(x1,y1,P^,CopyPut);
  Ax := x1;
  Ay := y1;
end;



procedure DoSaucer;
begin
  CreateSaucer(GetMaxY div 10);
  OldX := Ax;
  OldY := Ay;
  SetWriteMode(MiscCommand+SetGetImageReadOnly);
  GetImage(Ax,Ay,Ax+Xr,Ay+Yr,PO^);                 {get copy of initial image}
  SetWriteMode(MiscCommand+SetGetImageReadWrite);
  SetWriteMode(GetImageMode+ForeMoveWrite); {set getimage write mode}
  while not(Done) do
  begin
    Step := Random(r);
    if Step mod 2 > 0 then
      Step := -Step;
    Ax := Ax + Step;
    Step := Random(r);
    if Step mod 2 > 0 then
      Step := -Step;
    Ay := Ay + Step;
    Ax := limit(Ax,0,GetMaxX-Xr); {point to new location}
    Ay := limit(Ay,0,GetMaxY-Yr);

    {critical animation code here}
      if QuickAnimate then
      begin
        move(PI^,P^,AniSize);                  {get animation image again}
        PutImage(OldX,OldY,PO^,CopyPut);       {restore old image}
        GetImage(Ax,Ay,Ax+Xr,Ay+Yr,P^);        {get/put new image}
        move(P^,PO^,AniSize);                  {save the old image}
        if showarea then
          rectangle(Ax,Ay,Ax+Xr,Ay+Yr);
      end
      else
      begin
        PutImage(OldX,OldY,PO^,CopyPut);         {restore old image}
        GetImage(Ax,Ay,Ax+Xr,Ay+Yr,PO^);         {get/put new image}
        PutImage(Ax,Ay,PM^,AndPut);              {mask foreground}
        PutImage(Ax,Ay,PI^,OrPut);               {write new image}
      end;
      OldX := Ax;  {save the position}
      OldY := Ay;

    delay(MoveDelay);
    CH := #255;
    if Keypressed then
    begin
      CH := READKEY;
      IF CH = #0 THEN CH := char(ord(READKEY)+$80);
    end;
    if (CH >= '0') and (CH <= '9') then
      MoveDelay := sqr(ord(CH) - $30)*5
    else if {(CH = #$1B)} (CH < #32) or (upcase(CH) = 'Q') then
      Done := true;
  end;
end;

end.
