{The following unit contains one function.  This function will initialize the
Borland BGI interface in a Turbo Pascal program.  I wrote this unit in TP
5.5, but it should work for all versions of TP after 4.0.

The function performs two actions which I think can help graphics programs
immensely.  The first is to obtain the path for the BGI (and CHR) drivers
from an environmental variable BGIDIR.  The second action is to edit the
driver and mode passed to the initialization unit against what is detected
by TP.  The function returns a boolean to say if it was able to successfully
initialize the driver.

I hope this helps someone.
}
Unit BirdStuf;

Interface

Uses
	Dos,
	Graph;

Const
		Bird_DetectDriver = $0;
		Bird_Highest_Mode = $255;


	Function Init_Graphics (var GraphDriver, GraphMode : Integer) : Boolean;
	{	This function will initialize the Turbo Graphics for the requested
		graphics mode if and only if the requested mode is valid for the
		machine the function is run in.  Another feature of this function is
		that it will look for an environmental variable named 'BGIDIR'.  If
		this variable is found, it will attempt to initialize the graphics
		mode looking for the BGI driver using the string associated with BGIDIR
		as the path.  If the correct BGI driver is not available, or if there is
		not BGIDIR variable in the environment, it will attempt to initialize
		using the current directory. }


Implementation

	Function Init_Graphics (var GraphDriver, GraphMode : Integer) : Boolean;


	const
		ENV_BGI_PATH = 'BGIDIR';

	var
		Dtect_Driver,
		Dtect_Mode	: Integer;
		BGI_Path	: String;

	Begin { Init_Graphics }

		{ Default to not work }
		Init_Graphics := False;

		DetectGraph(Dtect_Driver, Dtect_Mode);
		If GraphDriver = Bird_DetectDriver then
			GraphDriver := Dtect_Driver;
		If Dtect_Driver = GraphDriver
		Then Begin { Drivers match }
			If GraphMode = Bird_Highest_Mode then
				GraphMode := Dtect_Mode;
			If GraphMode <= Dtect_Mode
			Then Begin { Mode OK }
				BGI_Path := GetEnv(ENV_BGI_PATH);
				InitGraph(GraphDriver,GraphMode,BGI_Path);
				if GraphResult = grOk
				then
					Init_Graphics := True
				Else Begin { Try current Directory }
					InitGraph(GraphDriver,GraphMode,'');
					if GraphResult = grOk then
						Init_Graphics := True;
				End; { Try current Directory }
			End; { Mode OK }
		End; { Drivers match }
	End; { Function Init_Graphics }

Begin { Unit BirdStuf }
End.
{
Mike Bird - B. Dalton, Bookseller                         bird@clavdivs.MN.ORG
Helen Bird - Hummingbird Tailors                         helen@clavdivs.MN.ORG
}