{************************************************
  The Bitmaps are loaded in SetUpWindow, it is shown
  in Paint and in WmLButtonDown, and it is destroyed
  in the Done procedure.
  There are two different methods of showing a bitmap
  in this example. The first displays it to the screen
  with the Paint method, the second in WmLButtonDown.
  To use the second method, just click on the screen
  with the left button.
************************************************}

program MyProgram;

uses WinTypes, WinProcs, OWindows, Strings;

{$R BmpPaint}

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

type
  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
      Foo1: HBitmap;
      Foo2: HBitmap;
    destructor Done; virtual;
    procedure SetUpWindow; virtual;
    procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure WmLButtonDown(var Msg: TMessage);
      virtual wm_First + wm_LButtonDown;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

destructor TMyWindow.Done;
begin
  DeleteObject(Foo1);
  DeleteObject(Foo2);
  inherited Done;
end;

procedure TMyWindow.SetUpWindow;
begin
  inherited SetUpWindow;
  Foo1 := LoadBitMap(HInstance, 'Foo1');
  Foo2 := LoadBitMap(HInstance, 'Foo2');
end;

procedure TMyWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  OldBitmap: HBitmap;
  MemDC: HDC;
begin
  MemDC := CreateCompatibleDC(PaintDC);
  OldBitmap := SelectObject(MemDC, Foo1);
  BitBlt(PaintDC, 10, 10, 64, 64, MemDC, 0, 0, SRCCopy);
  SelectObject(MemDC, OldBitmap);
  DeleteObject(MemDC);
end;

procedure TMyWindow.WmLButtonDown;
var
  PaintDC: HDC;
  MemDC: HDC;
  OldBitMap: HBitMap;
begin
  PaintDC := GetDC(HWindow);
  MemDC := CreateCompatibleDC(PaintDC);
  OldBitmap := SelectObject(MemDC, Foo2);
  BitBlt(PaintDC, 100, 10, 64, 64, MemDC, 0, 0, SRCCopy);
  SelectObject(MemDC, OldBitmap);
  DeleteObject(MemDC);
  ReleaseDC(HWindow, PaintDC);
end;


{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
