{************************************************}
{ finished simple example of using a combobox
  in a dialog. Just press the Set3 key to select
  a particular item                              }
{************************************************}

program MyProgram;

uses WinTypes, WinProcs, OWindows, ODialogs;
{$R ComboDlg}

{
MENU_1 MENU
BEGIN
	MENUITEM "Dialog", 105
END


DIALOG_1 DIALOG 18, 18, 142, 92
STYLE DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU
CAPTION "DIALOG_1"
BEGIN
	PUSHBUTTON "Ok", 1, 31, 68, 24, 14
	CONTROL "", 101, "COMBOBOX", CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 26, 13, 91, 53
	PUSHBUTTON "Set3", 1002, 81, 69, 24, 14, WS_CHILD | WS_VISIBLE | WS_TABSTOP
END
}

const
  cm_Dialog = 105;
  id_ListBox = 101;

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyDialog =^TMyDialog;
  TMyDialog = Object(TDlgWindow)
      ComboBox: PComboBox;
    Constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure SetUpWindow; virtual;
    procedure Set6(var MSg: TMessage);
      virtual id_First + 1002;
    procedure Ok(var Msg: TMessage);
      virtual id_First + idOk;
  end;

type
  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure CmDialog(var Msg: TMessage);
      virtual cm_First + cm_Dialog;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

constructor TMyDialog.Init(AParent: PWindowsObject; AName: PChar);
begin
  TDlgWindow.Init(AParent, AName);
  ComboBox := New(PComboBox, InitResource(@Self, Id_ListBox, 200));
end;

procedure TMyDialog.SetUpWindow;
var
  S: array[0..200] of Char;
  i: Integer;
begin
  TDlgWindow.SetUpWindow;
  for i := 0 to 20 do begin
    WvsPrintF(S, 'Item: %d', i);
    ComboBox^.AddString(S);
  end;
end;

procedure TMyDialog.Set6(var MSg: TMessage);
begin
  SendMessage(ComboBox^.HWindow, CB_SETCURSEL, 3, 0);
end;

procedure TMyDialog.Ok(var Msg: TMessage);
begin
  TDialog.Ok(Msg);
end;

constructor TMyWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  TWindow.Init(AParent, AName);
  Attr.Menu := LoadMenu(HInstance, 'Menu_1');
end;

procedure TMyWindow.cmDialog(var Msg: TMessage);
var
  D: PMyDialog;

begin
  D := new(PMyDialog, Init(@Self, 'Dialog_1'));
  Application^.ExecDialog(D);
  {ShowWindow(D^.HWindow, sw_Normal);}
end;


{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
