{$N+,E+}
{test of contour plot routines
 copyright 1988, Optimal Systems Laboratory, Plainfield, NJ}
program test(input,output);

uses crt,video,c_defs,contour;

const
  {setup for this particular piece of data}
  x_size = 50;
  y_size = 50;
  num_contours = 30;

var
  i,j : longint;
  max, min : longint;
  key : char;

begin
  {allocate memory to data and contour arrays, this must always be the
   first thing you do when using this package}
  init_array;
  {fill data array with sum of two Gaussians plus noise for this demo}
  min:=1000000;
  max:=-1000000;
  for  i:= 0 to x_size-1 do
    begin
      for  j:= 0 to y_size-1 do
        begin
          data_array_pointer^[i]^[j]:=round(
            30000.0*exp(-1*(sqr(i-35)+3.0*sqr(j-40))/450.0)+
            30000.0*exp(-1*(3.0*sqr(i-10)+sqr(j-15))/450.0)+
            random(1500));
          if (min>data_array_pointer^[i]^[j]) then
            min:=data_array_pointer^[i]^[j];
          if (max<data_array_pointer^[i]^[j]) then
            max:=data_array_pointer^[i]^[j];
        end;
    end;
  {now make the contour levels}
  for  i:= 0 to num_contours-1 do
    contours^[i]:=min+i*(max-min)/(num_contours-1);
  writeln('Filled data arrays, hit any key to continue.');
  write('After plotting finished, hit any key to return to DOS');
  key:=readkey;
  {go to graphics mode}
  init_graphics;
  {plot the data}
  contour_plot(x_size,y_size,num_contours);
  key:=readkey;
  {return to text screen}
  close_graphics;
end.
