Listing 1

program Serial_CRC;

uses HexOut;

const Feedback =    $8408;   { CRC-CCITT }
                  { $A001;     CRC-16    }
                  { $8000;     LRCC-16   }
var CRC: Word;


{ Process the CRC for a Single Byte }

Procedure UpdateCRC(B: Byte);
var i: Integer;
begin
   for i := 1 to 8 do begin
      if Odd(B) Xor Odd(CRC) then
         CRC := (CRC Shr 1) Xor Feedback
      else
         CRC := CRC Shr 1;
      B := B Shr 1;
   end;
end;


{Send a Message String }

Procedure SendString(S: String);
var i: Integer;
begin
   for i := 1 to Length(S) do
      UpdateCRC(Ord(S[i]));
end;


{ Send Message, Including CRC Bytes }

Procedure SendMessage(S: String);
var OldCRC: Word;
begin
   CRC := 0;
   SendString(S);
   OldCRC := CRC;
   Write('CRC Computed is ');
   WordLn(CRC);
   UpdateCRC(OldCRC);
   UpdateCRC(OldCRC Shr 8);
end;

begin
   SendMessage('THE,QUICK,BROWN,FOX,0123456789');
   WordLn(CRC);
   ReadLn;
end.

-------------------------------------------------------------------

Listing 2 -- Table-Driven Algorithm

{ Initialize the CRC Table for a bytewise CRC.
  This procedure works for any CRC code, if
  as ProcessByte is adjusted as needed.        }

Procedure MakeTable;
var i: Integer;
begin
   for i := 0 to 255 do begin
      CRC := 0;
      ProcessByte(i);
      Table[i] := CRC;
   end;
end;


{ Send a single byte using table-driven algorithm  }

Procedure SendByte(B: Byte);
begin
   CRC := (CRC Shr 8) Xor Table[B Xor Lo(CRC)];
end;

-------------------------------------------------------------------

Listing 3 -- Bytewise Generation of Table

{ This procedure creates the table for a bytewise CRC.
  The algorithm is specific to the CCITT CRC.  Other
  codes can be done in similar manner.               }

Procedure MakeTable;
var i: Integer;
    z: Byte;
begin
   for i := 0 to 255 do begin
      z := i Xor (i Shl 4);
      Table[i] := (z Shl 8) Xor (z Shl 3) Xor (z Shr 4);
   end;
end;

-------------------------------------------------------------------

Listing 4 -- Bytewise CRC without Table

{ This Procedure Permits Bytewise CRC Without the Need for
  a table.  The "table entry" is built "on the fly."
  Note that the algorithm is specific to the CCITT CRC.
  Other codes can be done in similar manner.              }

Procedure UpdateCRC(B: Byte);
begin
   B := B Xor Lo(CRC);
   B := B Xor (B Shl 4);
   CRC := (CRC Shr 8) Xor (B Shl 8) Xor (B Shl 3) Xor (B Shr 4);
end;

-------------------------------------------------------------------

Listing 5 -- XMODEM Algorithm

{ The XMODEM Algorithm shifts left instead of right }
{ This impacts most of the procedures.              }

{ Bytewise, table-driven algorithm for XMODEM }

Procedure SendByte(B: Byte);
begin
     CRC := (CRC Shl 8) Xor Table[B Xor Hi(CRC)];
end;

{ Table Builder for XMODEM }

Procedure MakeTable;
var i: Integer;
      z: Byte;
begin
     for i := 0 to 255 do begin
          z := i Xor (i Shr 4);
          Table[i] := z Xor (z Shl 5) Xor (z Shl 12);
     end;
end;


{ Message Protocol for XMODEM.  Note the two null bytes,
  and the way the BCC is sent. }

Procedure SendMessage(S: String);
var OldCRC: Word;
begin
     CRC := 0;
     SendString(S);
     OldCRC := CRC;
     Write('CRC Computed is ');
     WordLn(CRC);
   SendByte(OldCRC);
   SendByte(Hi(OldCRC));
end;
