
-------------------------------------------------------------------------------
  TITLE : Cursor Definition
-------------------------------------------------------------------------------
     This is a sample program that demonstrates how to change the cursor
     on an IBM PC.                                                           }

Program NoCursor;

var
   ch : char;
start,
endcur : integer;

procedure SetCursor (StartLine,EndLine : Integer);
{  This procedure does the actual cursor setting thru the TURBO
   INTR procedure                                                }

type Registers = record
                 ax,bx,cx,dx,bp,si,ds,es,flags : integer;
                 end;

var
   RegPack : Registers;
CxRegArray : Array [1..2] of Byte;
     CxReg : integer absolute CxRegArray;

begin
     CxRegArray [2] := Lo (StartLine);
     CxRegArray [1] := Lo (EndLine);
     With RegPack do
          begin
               ax := $0100;          {ah = 1 means set cursor type         }
               bx := $0;             {bx = page number, zero for us        }
               cx := CxReg;          {cx bits 4 to 0 = start line for      }
                                     {Cursor                               }
                                     {cl bits 4 to 0 = end line for cursor }
               intr ($10,RegPack);   {set cursor                           }
          end;
end;

procedure BoxCursor;
{  This procedure calls SetCursor to show a block (box) cursor  }

begin
     SetCursor (2,5);
end;

{-----------------------------------------------------------------------------
  TITLE : Cursor Definition
------------------------------------------------------------------------------}

procedure NoCursor;
{ This procedure calls SetCursor to turn the cursor off                    }

begin
     SetCursor (32,0);      {Setting bit 5 turns off cursor                }
end;

procedure ULCursor;
{ This procedure calls SetCursor to show the 'underscore' cursor           }

begin
     SetCursor (6,7);
end;


begin
     write ('Box:'); BoxCursor; read (kbd, ch); writeln;
     write ('No:'); NoCursor; read (kbd, ch); writeln;
     write ('UL:'); ULCursor; read (kbd, ch); writeln;
end.


