{ routine to read and set date and time. }

{ each routine requires the following definitions }
{ but does not require the other routines.        }

type datetimetype = string[8];
     regtype      = record
                      ax,bx,cx,dx,bp,si,di,ds,es,flags:integer
                    end;

function date: datetimetype;
  { returns current date in form '08/31/84'. }

var reg:     regtype;
    y,m,d,w: datetimetype;
    i:       integer;

begin
  reg.ax:=$2A00;
  intr($21,reg);
  str(reg.cx:4,y);
  delete(y,1,2);
  str(hi(reg.dx):2,m);
  str(lo(reg.dx):2,d);
  w:=m + '/' + d + '/' + y;
  for i:=1 to length(w) do if w[i]=' ' then w[i]:='0';
  date:=w
end;

function time: datetimetype;
  { returns current time in form '08:13:59'. }

var reg:     regtype;
    h,m,s,w: datetimetype;
    i:       integer;

begin
  reg.ax:=$2C00;
  intr($21,reg);
  str(hi(reg.cx):2,h);
  str(lo(reg.cx):2,m);
  str(hi(reg.dx):2,s);
  w:=h + ':' + m + ':' + s;
  for i:=i to length(w) do if w[i]=' ' then w[i]:='0';
  time:=w;
end;

procedure setdate(x:datetimetype);
  { sets date.  Accepts string in format '08/31/84'. }

var reg:            regtype;
    rh,rl,c1,c2,c3: integer;

begin
  reg.ax:=$2B00;
  val(x[1]+x[2],rh,c1);    { month goes in DH }
  val(x[4]+x[5],rl,c2);    { day   goes in DL }
  reg.dx:=rh*256 + rl;
  val(x[7]+x[8],rl,c3);    { year  goes in CX }
  reg.cx:=rl + 1900;
  if rl<80 then reg.cx:=reg.cx+100;  { 21st century }
  c1:=c1+c2+c3;            { return codes from VAL }
  if c1=0 then intr($21,reg);
  if c1+lo(reg.ax)<>0 then
    begin
      writeln;
      writeln('Error -- Invalid date, ''',x,'''');
      halt;
    end;
end;

procedure settime(x:datetimetype);
  { sets time.  accepts string in format '08:13:59'. }

var reg:            regtype;
    rh,rl,c1,c2,c3: integer;

begin
  reg.ax:=$2D00;
  val(x[1]+x[2],rh,c1);       { hours   go in CH }
  val(x[4]+x[5],rl,c2);       { minutes go in CL }
  reg.cx:=rh*256+rl;
  val(x[7]+x[8],rh,c3);       { seconds go in DH }
  reg.dx:=rh*256;
  c1:=c1+c2+c3;               { return codes from VAL }
  if c1=0 then intr($21,reg);
  if c1+lo(reg.ax)<>0 then
    begin
      writeln;
      writeln('Error -- Invalid time ''',x,'''');
      halt;
    end;
end;

 {  sample program calling DATE, TIME, SETDATE, and SETTIME.
   var x:string[8];
     begin
       writeln(DATE,' ',TIME);
       writeln('What is the date?');
       readln(x);
       setdate(x);
       writeln('What is the time?');
       readln(x);
       settime(x);

    end.

  }                                                               