{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Demo program                                 }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

{
DIALOG_1 DIALOG 18, 18, 142, 92
STYLE DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU
CAPTION "DIALOG_1"

BEGIN
	PUSHBUTTON "New Window", 101, 43, 59, 57, 14, WS_CHILD | WS_VISIBLE | WS_TABSTOP
END}

program DlgLaunchWindow;

uses WinTypes, WinProcs, OWindows, ODialogs, OStdWnds, BWCC;
{$R DlgWind2}
type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

const
  Wm_NewWindow = Wm_User + 0;
  id_MyButton = 101;
  cm_Dialog = 100;

type
  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(P: PWindowsObject; N: PChar);
    procedure Dialog(var Msg: TMessage);
      virtual cm_First + cm_Dialog;
    procedure NewWindow(var Msg: TMessage);
      virtual wm_First + wm_NewWindow;

  end;

  PMyDialog = ^TMyDialog;
  TMyDialog = Object(TDlgWindow)
    procedure DoButton(var Msg: TMessage);
      virtual id_First + id_MyButton;
  end;



{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

constructor TMyWindow.Init(P: PWindowsObject; N: PChar);
begin
  inherited Init(P, N);
  Attr.Menu := LoadMenu(hInstance, 'Menu');
end;

procedure TMyWindow.Dialog(var Msg: TMessage);
var
  D: PMyDialog;
begin
  D := New(PMyDialog, Init(@Self, 'Dialog'));
  Application^.MakeWindow(D);
  ShowWindow(D^.Hwindow, sw_Normal);
end;

procedure TMyWindow.NewWindow(var MSg: TMessage);
var
  w: PEditWindow;
begin
  W := New(PEditWindow, Init(@Self, 'Sam'));
  W^.Attr.Style := W^.Attr.Style or ws_SysMenu;
  Application^.MakeWindow(W);
  ShowWindow(W^.HWindow, sw_ShowNormal);
end;


procedure TMyDialog.DoButton(var Msg: TMessage);
begin
  SendMessage(Parent^.HWindow, wm_NewWindow, 0, 0);
  CloseWindow;
end;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
