{ NOTE: This is a Turbo Pascal 4.0 program, but you can convert
  it for TP3 easily enough. There are two places you have to
  change, both marked with "(*TP3*)". Look for that marker and
  follow the instructions. }

{$R+}
(*TP3*) (* To use with TP3, comment out the line above and
           UN-comment out the line below *)
(* {$R+,C-} *)

PROGRAM LineDraw;
(*TP3*) (* Delete the next line for use with TP3 *)
USES
   CRT, TURBO3;

CONST
  rows = 25;              { screen size vertically and horizontally }
  cols = 80;

VAR
  CH, CH2  : Char;        { character read from keyboard }
  screen   : ARRAY[0..26, 0..81] OF Char; { YES it is too big }
  drawing  : Boolean;     { true while drawing }
  Erase    : Boolean;     { true while drawing and erasing }
  row, col : Integer;     { current screen location }
  style    : Integer;     { line style -
                           0 = blank, 1 = single, 2 = double }
  holdstyle : Integer;    { hold style when erasing }

  PROCEDURE PUT (movement : Integer);
  { movement is direction of travel: 1=up, 2=right, 3=down, 4=left }

  TYPE quad = ARRAY[1..4] OF Char;

    { this array is the heart of the technique. For each drawing
      character, it describes the connecting requirements starting at
      the top and moving clockwise around it. Thus, vertical single
      line is 1010. }

  CONST connect : ARRAY[#179..#219] OF quad =
  ('1010', '1011', '1012', '2021', '0021', '0012',
   '2022', '2020', '0022', '2002', '2001', '1002',
   '0011', '1100', '1101', '0111', '1110', '0101',
   '1111', '1210', '2120', '2200', '0220', '2202',
   '0222', '2220', '0202', '2222', '1202', '2101',
   '0212', '0121', '2100', '1200', '0210', '0120',
   '2121', '1212', '1001', '0110', '    ');

   { default character, for impossible matches }
   line : ARRAY[0..2, 1..4] OF Char =
     ('    ', #179#196#179#196, #186#205#186#205);
   { #179  single vertical; #196  horizontal;
     #186  double vertical; #205  horizontal }

  VAR
    c    : Char;              { character found to display }
    hold : quad;              { pattern for character to find }

    FUNCTION check (c : Char; j : Integer): char;
    { Returns the number of lines needed to match up with the
      neighbouring character c. J is a number from 1 to 4
      representing the connecting direction }

    BEGIN
      IF (c >= #179) AND (c <= #218) THEN
        check := connect[c][j]
      ELSE check := '0';
    END;

  BEGIN
    { check all four neighbours }
    hold [1] := check(screen[row-1, col], 3); {A}
    hold [2] := check(screen[row, col+1], 4);
    hold [3] := check(screen[row+1, col], 1);
    hold [4] := check(screen[row, col-1], 2);
    hold [movement] := Chr(style+Ord('0'));
    { required pattern is built - does any character match it? }
    connect[#219] := hold;     {B}
    c := #179;
    While connect[c] <> hold DO c := Succ(c);
    { If no match, use default plain line instead }
    IF c = #219 THEN c := line [style, movement];
    screen[row, col] := c;
    Write (c, ^H);
  END;

BEGIN              { draw }
  ClrScr;
  WriteLn('Line Drawing Made Easy');
  WriteLn('Touch :');
  WriteLn;
  WriteLn(' UP');
  WriteLn(' LEFT');
  WriteLn(' RIGHT');
  WriteLn(' DOWN');
  WriteLn(' 7 - START / STOP ERASING');
  WriteLn(' 8 - SWITCH LINE STYLE TO OPPOSITE TYPE');
  WriteLn(' 9 - START / STOP DRAWING');
  WriteLn(' Esc - EXIT');
  WriteLn;
  WriteLn(' Touch <Enter> to begin');
  Readln;
  ClrScr;
  drawing := True;
  Erase := False;
  ClrScr;
  FillChar (screen, SizeOf(screen), ' ');
  row := 12;
  col := 40;
  style := 1;
  REPEAT
    GoToXY(col, row);
    Read(Kbd, CH);
    IF (CH = #27) AND KeyPressed THEN Read (Kbd, CH2)
    ELSE CH2 := #0;
    CH := UpCase(CH);
    IF drawing THEN
      CASE CH OF
        #27 : CASE CH2 OF
                'H' : IF row > 1 THEN BEGIN put(1); row := row-1; END;
                'P' : IF row < rows THEN BEGIN put(3); row := row+1; END;
                'M' : IF col < cols THEN BEGIN put(2); col := col+1; END;
                'K' : IF col > 1 THEN BEGIN put(4); col := col-1; END;
              END;             {case CH2}
        '9' : BEGIN
                IF Erase THEN
                  BEGIN
                    style := holdstyle;
                    Erase := False;
                  END;
                drawing := False;
              END;
        '8' : IF NOT Erase THEN style := style MOD 2+1
              ELSE write (#7);
        '7' : IF style <> 0 THEN
                BEGIN
                  holdstyle := style;
                  style := 0;
                  Erase := True;
                END
              ELSE
                BEGIN
                  style := holdstyle;
                  Erase := False;
                END;
      END  {CASE CH}
    ELSE
      CASE CH OF
        #27 : CASE CH2 OF
                'H' : IF row > 1 THEN row := row-1;
                'P' : IF row < rows THEN row := row+1;
                'M' : IF col < cols THEN col := col+1;
                'K' : IF col > 1 THEN col := col-1;
              END; {case CH2}
        '9' : drawing := True;
      END; {CASE CH}
  UNTIL (CH = #27) AND (CH2 = #0);
END.          {draw}