PROGRAM EXAMPLE2;

{This program serves as an example of how to write a Turbo Pascal program that
 utilizes DXFREAD.TPU}

USES DXFREAD;   {Allows program to use DXFREAD}

PROCEDURE DO_POINT(LAYER:STRING);

VAR
  X,Y,Z,ELEV,THICK:REAL;

BEGIN
  GET_POINT(X,Y,Z,ELEV,THICK);
  WRITELN;
  WRITELN('POINT IN LAYER ',LAYER);
  WRITELN('DRAWN AT ',X,',',Y,',',Z);
  WRITELN('THE ELEVATION IS ',ELEV,' AND THE THICKNESS IS',THICK);
END;


PROCEDURE DO_LINE(LAYER:STRING);

VAR
  X1,Y1,Z1,X2,Y2,Z2,ELEV,THICK:REAL;

BEGIN
  GET_LINE(X1,Y1,Z1,X2,Y2,Z2,ELEV,THICK);
  WRITELN;
  WRITELN('LINE IN LAYER ',LAYER);
  WRITELN('DRAWN FROM ',X1,',',Y1,',',Z1);
  WRITELN('DRAWN TO ',X2,',',Y2,',',Z2);
  WRITELN('THE ELEVATION IS ',ELEV,' AND THE THICKNESS IS ',THICK);
END;



PROCEDURE DO_ARC(LAYER:STRING);

VAR
  X,Y,Z,RAD,ANG1,ANG2,ELEV,THICK:REAL;

BEGIN
  GET_ARC(X,Y,Z,RAD,ANG1,ANG2,ELEV,THICK);
  WRITELN;
  WRITELN('ARC IN LAYER ',LAYER);
  WRITELN('CENTER POINT AT',X,',',Y,',',Z, 'WITH A RADIUS OF ',RAD);
  WRITELN('FROM ',ANG1,' DEGREES TO ',ANG2,' DEGREES');
  WRITELN('THE ELEVATION IS ',ELEV,' AND THE THICKNESS IS ',THICK);
END;


PROCEDURE DO_CIRCLE(LAYER:STRING);

VAR
  X,Y,Z,RAD,ELEV,THICK:REAL;

BEGIN
  GET_CIRCLE(X,Y,Z,RAD,ELEV,THICK);
  WRITELN;
  WRITELN('ARC IN LAYER ',LAYER);
  WRITELN('CENTER POINT AT',X,',',Y,',',Z, 'WITH A RADIUS OF ',RAD);
  WRITELN('THE ELEVATION IS ',ELEV,' AND THE THICKNESS IS ',THICK);
END;


PROCEDURE DO_PLINE(LAYER:STRING);

VAR
  X,Y,Z,BEGIN_WIDTH,END_WIDTH,ELEV,THICK : REAL;
  MESH,MCLOSED,NCLOSED : BOOLEAN;
  M,N:INTEGER;
  ENTID:BYTE;
  ENTNAME:STRING;

BEGIN
  WRITELN('GET PLINE');
  GET_PLINE(MESH,MCLOSED,NCLOSED,M,N,BEGIN_WIDTH,END_WIDTH,ELEV,THICK);
  WRITELN;
  IF NOT MESH THEN
      BEGIN
        REPEAT;
          GET_ENT(ENTID,ENTNAME,LAYER);
          IF (ENTID=10) THEN
          BEGIN
            GET_VERTEX(X,Y,Z,BEGIN_WIDTH,END_WIDTH,ELEV,THICK);
            WRITELN('VERTEX POINT AT COORDINATE ',X,',',Y,',',Z);
          END;
        UNTIL ENTID=11;  {END OF POLYLINE}
      END;
END;


PROCEDURE MAIN;

VAR
  ENTID:BYTE;
  ENTNAME,LAYER : STRING;
  FILENAME : STRING;

BEGIN
  WRITELN('ENTER NAME OF INPUT DXF FILE .');
  READLN(FILENAME);
  OPEN_DXF(FILENAME);
  REPEAT;
    GET_ENT(ENTID,ENTNAME,LAYER);
    CASE ENTID OF
      1 : DO_POINT(LAYER);
      2 : DO_LINE(LAYER);
      4 : DO_ARC(LAYER);
      5 : DO_CIRCLE(LAYER);
      9 : DO_PLINE(LAYER);
    END; {CASE}
  UNTIL ENTID=0;
  CLOSE_DXF;
END;

BEGIN
  MAIN;
END.
