program SaveDemo;
(*
------------------------------------------------------------------
  Demonstrates the use of the EGA graphics screen saving and
  restoring routines from the EGASave unit.

  Author     : John Sieraski (Borland technical support)
  Last update: 11/17/88
  Ware-ness  : Released to the public domain by the author
------------------------------------------------------------------
*)

{$R-}
{$S-}

uses
  Crt, Graph, EGASave;

var
  GraphDriver : integer;
  GraphMode   : integer;
  GraphError  : integer;
  Buffer      : EGABuffer; { Used to store an EGA screen image }
  Result      : integer;

procedure Wait;
var
  Ch : char;
begin
  Ch := ReadKey;
  while KeyPressed do
    Ch := ReadKey;
end;

procedure RandomBars;
{ Draw random bars on the screen }
const
  MaxBars = 100; { The number of random bars drawn }
var
  MaxWidth  : integer;
  MaxHeight : integer;
  Color     : word;
  Count     : integer;
begin
  MaxWidth := GetMaxX;
  MaxHeight := GetMaxY;
  for Count := 1 to MaxBars do
  begin
    Color := Random(16);
    SetColor(Color);
    SetFillStyle(Random(CloseDotFill)+1, Color);
    Bar3D(Random(MaxWidth), Random(MaxHeight),
          Random(MaxWidth), Random(MaxHeight), 0, TopOff);
  end;
  SetColor(GetMaxColor);
  Rectangle(0, 0, GetMaxX, GetMaxY); { Draw screen border }
  SetTextJustify(CenterText, CenterText);
  OutTextXY(GetMaxX div 2, GetMaxY div 2, 'Press any key to continue:');
end; { RandomBars }

var
  OldExitProc : pointer;

{$F+}
procedure MyExitProc;
begin
  ExitProc := OldExitProc;
  CloseGraph;
end;
{$F-}

begin
  OldExitProc := ExitProc; { Save old exit procedure address }
  ExitProc := @MyExitProc; { Install new exit procedure }

  GraphDriver := EGA;  { Force EGA 640x350 16 color mode }
  GraphMode := EGAHi;
  InitGraph(GraphDriver, GraphMode, ''); { Assumes EGAVGA.BGI in default dir }
  GraphError := GraphResult;
  if GraphError <> grOK then
  begin
    Writeln('Graphics ERROR: ', GraphErrorMsg(GraphError));
    Write('Press any key to Halt:');
    Wait;
    Halt;
  end;
  DirectVideo := false; { Turn off Crt's direct screen writes }
  if not AllocateBuffer(Buffer) then { Attempt to allocate buffer from Heap }
  begin
    Writeln('Error: not enough heap space to allocate buffer');
    Write('Press any key to Halt:');
    Wait;
    Halt;
  end;
  RandomBars;             { Draw random bars }
  SaveEGAScreen(Buffer);  { Save graphics image into Buffer }
  Wait;
  ClearDevice;
  OutTextXY(GetMaxX div 2, GetMaxY div 2, 'Screen saved, press any key to'+
                                           ' restore it from the Buffer:');
  Wait;
  RestoreEGAScreen(Buffer); { Restore graphics image from Buffer }
  Wait;
  ClearDevice;
  OutTextXY(GetMaxX div 2, GetMaxY div 2, 'Press any key to save it to disk:');
  Wait;
  ClearDevice;
  RandomBars;
  Wait;
  Result := WriteEGAScreen('Save.ega'); { Save graphics image to disk }
  if Result <> OK then
  begin
    Writeln('IOError #', Result:1, ' while saving screen to disk');
    Write('Press any key to Halt:');
    Wait;
    Halt;
  end;
  ClearDevice;
  OutTextXY(GetMaxX div 2, GetMaxY div 2, 'Screen saved, press any key to'+
                                          ' restore it from disk file:');
  Wait;
  ClearDevice;
  Result := ReadEGAScreen('Save.ega'); { Restore graphics image from disk }
  if Result <> OK then
  begin
    Writeln('IOError #', Result:1, ' while reading screen from disk');
    Write('Press any key to Halt:');
    Wait;
    Halt;
  end;
  Wait;
end.