/*
EXEMOD.H - Header file for EXEMOD.C

Kevin Dean
16 Kellythorne Drive
Don Mills, Ontario
Canada  M3A 2L4

March 27, 1990

Copyright (c) 1990 by Kevin Dean

For Turbo C versions 2.0 and above.  This code is public domain.
*/


struct exeheader
  {
  unsigned id;			/* EXE file id */
  unsigned bytemod;		/* Load module image size mod 512 */
  unsigned pages;		/* File size (including header) div 512 */
  unsigned reloc_items;		/* Number of relocation table items */
  unsigned size;		/* Header size in 16-byte paragraphs */
  unsigned minparagraphs;	/* Minimum number of paragraphs above program */
  unsigned maxparagraphs;	/* Maximum number of paragraphs above program */
  unsigned stackseg;		/* Displacement of stack segment */
  unsigned spreg;		/* Initial SP register value */
  int checksum;			/* Word checksum - negative sum (not used) */
  unsigned ipreg;		/* Initial IP register value */
  unsigned codeseg;		/* Displacement of code segment */
  unsigned first_reloc;		/* First relocation item */
  unsigned ovln;		/* Overlay number */
  };

#define EXEH_SIZE  sizeof(struct exeheader)


/* EXE file signature */
#define EXE_ID  0x5A4D


#ifndef TRUE
#define TRUE   1
#define FALSE  0
#endif


/* Function prototypes */
int exemodify(const char *progname, int keepdt, ...);