//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  ERROR NUMBERS (ANSI and POSIX)
//
// XENIX is a trademark of Microsoft Corporation.
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#if !defined(__ERRNO_H_INCLUDED)

//
// ANSI Requires these to be defined, and positive.
//
// How I would like to change these, as they conflict with MS-DOS error
// returns!  Unfortunately, a *lot* of code assumes these values.
//
#define EDOM        33          /* (XENIX = 33) ANSI Maths domain error */
#define ERANGE      34          /* (XENIX = 34) ANSI Maths range error */

//
// To be strict, this is not an error code, and is against the spirit of
// the Standard.  Only user code may assign this value to errno.
//
#define EZERO       0

//
// Since neither ANSI nor POSIX.1 give numeric values to error codes,
// MS-DOS error return values are mapped directly into errno.  Although
// _doserrno is supported (as the underlying value of errno in a single
// threaded library), code should not depend upon it or use it.
//
// Borland C uses MS-DOS errors, although allows some library routines to
// assign POSIX errors that have no meaning under MS-DOS (e.g. as errors
// from "system calls" that MS-DOS does not have); whereas Microsoft C
// attempts to retain numeric compatibility with XENIX.
//
// POSIX.1 error codes that have no meaning under MS-DOS are mapped into
// negative integers.  ANSI functions that assign to errno may only assign
// positive values.  However, the Standard dictates that all NON-ZERO values
// are error codes.
//
#define EINVFUNC    1   /* Invalid function number */
#define ENOENT      2   /* File not found (XENIX =  2) */
#define ENOPATH     3   /* Path not found */
#define EMFILE      4   /* Too many open files (XENIX = 24) */
#define EACCESS     5   /* Access denied (XENIX = 13) */
#define EBADF       6   /* Bad file descriptor (XENIX =  9) */
#define EARENA      7   /* Memory arena corrupted */
#define ENOMEM      8   /* No room in memory (XENIX = 12) */
#define EFAULT      9   /* Invalid memory address (XENIX = 14) */
#define EINVENV     10  /* Invalid environment */
#define EINVFMT     11  /* Invalid format */
#define EINVACC     12  /* Invalid Access */
#define EINVDAT     13  /* Invalid data */
#define ENODEV      15  /* No driver for that device (XENIX = 19) */
#define ECURDIR     16  /* Cannot remove current directory */
#define EXDEV       17  /* Different device (XENIX = 18 BOR=22) */
#define ENMFILES    18  /* No more files */
#define EROFS       19  /* Read-Only File system (XENIX = 30) */
#define ENXIO       20  /* Unknown device unit (XENIX =  6) */
#define ENREADY     21  /* Device not ready */
#define EIOCMD      22  /* Unknown IO command */
#define ECRC        23  /* CRC error */
#define EBADRQST    24  /* Bad IO request packet */
#define ESEEK       25  /* Seek error */
#define EMEDIUM     26  /* Unknown medium type */
#define ENSECTOR    27  /* Sector not found */
#define EOOPAPER    28  /* Out of Paper */
#define EIOWRITE    29  /* Write error */
#define EIOREAD     30  /* Read error */
#define EIOGENRL    31  /* General Failure error */
#define ENSHARE     32  /* Sharing violation */
#define EDEADLOCK   33  /* Locking violation (XENIX = 36) */
#define EDISKCHANGE 34  /* Unauthorised disk change */
#define ENFCB       35  /* FCB not available */

#define E2BIG       40  /* Argument list too large (XENIX =  7 BOR=20) */
#define ENOEXEC     41  /* File is not in executable format (XENIX =  8 BOR=21) */
#define ECHILD      42  /* No child processes to wait for (XENIX = 10) */
#define EAGAIN      43  /* No more process slots available (XENIX = 11) */
#define EINVAL      44  /* Invalid arguments to system call (XENIX = 22 BOR=19) */
#define ENOSPC      45  /* No space left on device (XENIX = 28) */

#define EEXIST      80  /* File already exists (XENIX = 17 BOR=35) */
#define EDUPFCB     81  /* Duplicate FCB found */
#define EMKDIR      82  /* Cannot create directory */
#define ECRITFAILED 83  /* Fail after int 24H */

#define EPERM       -1  /* (XENIX =  1) Permission denied */
#define ESRCH       -3  /* (XENIX =  3) No such process */
#define EINTR       -4  /* (XENIX =  4) System call interrupted */
#define EIO         -5  /* (XENIX =  5) Physical I/O error */
#define ENOTBLK     -15 /* (XENIX = 15) Not a Block device */
#define EBUSY       -16 /* (XENIX = 16) Resource busy */
#define ENOTDIR     -20 /* (XENIX = 20) Directory operation on non-directory */
#define EISDIR      -21 /* (XENIX = 21) File operation on directory */
#define ENFILE      -23 /* (XENIX = 23) System file table full */
#define ENOTTY      -25 /* (XENIX = 25) Not a TTY device */
#define ETXTBSY     -26 /* (XENIX = 26) File is a running program */
#define EFBIG       -27 /* (XENIX = 27) File is too large */
#define ESPIPE      -29 /* (XENIX = 29) Cannot SEEK on a pipe */
#define EMLINK      -31 /* (XENIX = 31) Too many links */
#define EPIPE       -32 /* (XENIX = 32) Write on broken pipe */
#define EUCLEAN     -35 /* (XENIX = 35) */
#define ENAMETOOLONG    -40 /* Filename is too long */
#define ENOLCK      -41 /* No locks available */
#define ENOSYS      -42 /* Function not supported on operating system */
#define ENOTEMPTY   -43 /* Directory not empty */
#define ENOTTTY     -44 /* Inappropriate ioctl() operation */

#define EDEADLK     EDEADLOCK

extern int _CDECL _DosErrno;                        // DOS system error
extern const char * const _CDECL _Sys_ErrList[];    // Error messages
extern const int _CDECL _Sys_NumErrs;               // Size of above

extern "C" {

int *   _CDECL  _Errno  (void);

char *  _CDECL  _Strerror   (int, char *);

#if _POSIX1_SOURCE > 0
#define sys_errlist _Sys_ErrList
#define sys_nerr    _Sys_NumErrs
#endif

}

//
//	ANSI states that errno is a MACRO which expands to a modifiable lvalue.
//
//	For POSIX.1 compatibility, if the macro is #undef'd, then this
//	implementation will fall back to an external int variable.  However,
//	this variable is NOT declared in any standard header.
//
//	Multithreaded programs must NOT look behind the errno macro.
//
#define errno (*_Errno())

#if _MSDOS_SOURCE > 0
#define _doserrno   _DosErrno
#endif

#define __ERRNO_H_INCLUDED
#endif
