{$S-,R-,V-,D-,T-}

unit FastWr;
  {-Fast screen writing routines}

interface

type
  DisplayType = (Monochrome, CGA, EGA, MCGA, VGA);
var
  BaseOfScreen : Word;       {Base address of video memory}
  WaitForRetrace : Boolean;  {Check for snow on color cards?}

procedure FastWrite(St : string; Row, Col, Attr : Byte);
  {-Writes St at Row,Col in Attr (video attribute) without snow}

procedure FastWriteNA(St : string; Row, Col : Byte);
  {-Writes St at Row,Col without snow, but doesn't change video attributes}

procedure ChangeAttribute(Number : Word; Row, Col, Attr : Byte);
  {-Changes Number video attributes to Attr starting at Row,Col}

procedure MoveFromScreen(var Source, Dest; Length : Word);
  {-Moves Length words from Source (video memory) to Dest without snow}

procedure MoveToScreen(var Source, Dest; Length : Word);
  {-Moves Length words from Source to Dest (video memory) without snow}

function CurrentDisplay : DisplayType;
  {-Returns type of the currently active display}

procedure ReinitFastWrite;
  {-Initializes WaitForRetrace and BaseOfScreen. Called automatically before
    program starts.}

implementation

  {$L FASTWR}

  {$F+}
  procedure FastWrite(St : string; Row, Col, Attr : Byte);
    {-Writes St at Row,Col in Attr (video attribute) without snow}
    external {FASTWR} ;

  procedure FastWriteNA(St : string; Row, Col : Byte);
    {-Writes St at Row,Col without snow, but doesn't change video attributes}
    external {FASTWR} ;

  procedure ChangeAttribute(Number : Word; Row, Col, Attr : Byte);
    {-Changes Number video attributes to Attr starting at Row,Col}
    external {FASTWR} ;

  procedure MoveFromScreen(var Source, Dest; Length : Word);
    {-Moves Length words from Source (video memory) to Dest without snow}
    external {FASTWR} ;

  procedure MoveToScreen(var Source, Dest; Length : Word);
    {-Moves Length words from Source to Dest (video memory) without snow}
    external {FASTWR} ;

  function CurrentDisplay : DisplayType;
    {-Returns type of the currently active display}
    external {FASTWR} ;

  function CurrentVideoMode : Byte;
    {-Returns current video mode}
    external {FASTWR} ;
  {$F-}

  procedure ReinitFastWrite;
    {-Initializes WaitForRetrace and BaseOfScreen}
  begin                      {InitFastWrite}
    {initialize WaitForRetrace and BaseOfScreen}
    if CurrentVideoMode = 7 then
      BaseOfScreen := $B000  {Mono}
    else
      BaseOfScreen := $B800; {Color}
    WaitForRetrace := (CurrentDisplay = CGA);
  end;                       {InitFastWrite}

begin
  ReinitFastWrite;
end.
